@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.inputs

import com.pulumi.azurenative.servicefabric.inputs.FrontendConfigurationArgs.builder
import com.pulumi.azurenative.servicefabric.kotlin.enums.IPAddressType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the frontend configurations for the node type.
 * @property applicationGatewayBackendAddressPoolId The resource Id of application gateway backend address pool. The format of the resource Id is '/subscriptions/<subscriptionId>/resourceGroups/<resourceGroupName>/providers/Microsoft.Network/applicationGateways/<applicationGatewayName>/backendAddressPools/<backendAddressPoolName>'.
 * @property ipAddressType The IP address type of this frontend configuration. If omitted the default value is IPv4.
 * @property loadBalancerBackendAddressPoolId The resource Id of the Load Balancer backend address pool that the VM instances of the node type are associated with. The format of the resource Id is '/subscriptions/<subscriptionId>/resourceGroups/<resourceGroupName>/providers/Microsoft.Network/loadBalancers/<loadBalancerName>/backendAddressPools/<backendAddressPoolName>'.
 * @property loadBalancerInboundNatPoolId The resource Id of the Load Balancer inbound NAT pool that the VM instances of the node type are associated with. The format of the resource Id is '/subscriptions/<subscriptionId>/resourceGroups/<resourceGroupName>/providers/Microsoft.Network/loadBalancers/<loadBalancerName>/inboundNatPools/<inboundNatPoolName>'.
 */
public data class FrontendConfigurationArgs(
    public val applicationGatewayBackendAddressPoolId: Output<String>? = null,
    public val ipAddressType: Output<Either<String, IPAddressType>>? = null,
    public val loadBalancerBackendAddressPoolId: Output<String>? = null,
    public val loadBalancerInboundNatPoolId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabric.inputs.FrontendConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabric.inputs.FrontendConfigurationArgs =
        com.pulumi.azurenative.servicefabric.inputs.FrontendConfigurationArgs.builder()
            .applicationGatewayBackendAddressPoolId(
                applicationGatewayBackendAddressPoolId?.applyValue({ args0 ->
                    args0
                }),
            )
            .ipAddressType(
                ipAddressType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .loadBalancerBackendAddressPoolId(loadBalancerBackendAddressPoolId?.applyValue({ args0 -> args0 }))
            .loadBalancerInboundNatPoolId(loadBalancerInboundNatPoolId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FrontendConfigurationArgs].
 */
@PulumiTagMarker
public class FrontendConfigurationArgsBuilder internal constructor() {
    private var applicationGatewayBackendAddressPoolId: Output<String>? = null

    private var ipAddressType: Output<Either<String, IPAddressType>>? = null

    private var loadBalancerBackendAddressPoolId: Output<String>? = null

    private var loadBalancerInboundNatPoolId: Output<String>? = null

    /**
     * @param value The resource Id of application gateway backend address pool. The format of the resource Id is '/subscriptions/<subscriptionId>/resourceGroups/<resourceGroupName>/providers/Microsoft.Network/applicationGateways/<applicationGatewayName>/backendAddressPools/<backendAddressPoolName>'.
     */
    @JvmName("bioftqdmnrumsvrs")
    public suspend fun applicationGatewayBackendAddressPoolId(`value`: Output<String>) {
        this.applicationGatewayBackendAddressPoolId = value
    }

    /**
     * @param value The IP address type of this frontend configuration. If omitted the default value is IPv4.
     */
    @JvmName("xmjiyqhwtpxdqiii")
    public suspend fun ipAddressType(`value`: Output<Either<String, IPAddressType>>) {
        this.ipAddressType = value
    }

    /**
     * @param value The resource Id of the Load Balancer backend address pool that the VM instances of the node type are associated with. The format of the resource Id is '/subscriptions/<subscriptionId>/resourceGroups/<resourceGroupName>/providers/Microsoft.Network/loadBalancers/<loadBalancerName>/backendAddressPools/<backendAddressPoolName>'.
     */
    @JvmName("sxvdelwxpdunemlo")
    public suspend fun loadBalancerBackendAddressPoolId(`value`: Output<String>) {
        this.loadBalancerBackendAddressPoolId = value
    }

    /**
     * @param value The resource Id of the Load Balancer inbound NAT pool that the VM instances of the node type are associated with. The format of the resource Id is '/subscriptions/<subscriptionId>/resourceGroups/<resourceGroupName>/providers/Microsoft.Network/loadBalancers/<loadBalancerName>/inboundNatPools/<inboundNatPoolName>'.
     */
    @JvmName("ocwnybgoxdlakbsy")
    public suspend fun loadBalancerInboundNatPoolId(`value`: Output<String>) {
        this.loadBalancerInboundNatPoolId = value
    }

    /**
     * @param value The resource Id of application gateway backend address pool. The format of the resource Id is '/subscriptions/<subscriptionId>/resourceGroups/<resourceGroupName>/providers/Microsoft.Network/applicationGateways/<applicationGatewayName>/backendAddressPools/<backendAddressPoolName>'.
     */
    @JvmName("xjqdbpdtdjrhebre")
    public suspend fun applicationGatewayBackendAddressPoolId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationGatewayBackendAddressPoolId = mapped
    }

    /**
     * @param value The IP address type of this frontend configuration. If omitted the default value is IPv4.
     */
    @JvmName("dhcbmotptceccqrg")
    public suspend fun ipAddressType(`value`: Either<String, IPAddressType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddressType = mapped
    }

    /**
     * @param value The IP address type of this frontend configuration. If omitted the default value is IPv4.
     */
    @JvmName("wgupyfnbrkwlflql")
    public fun ipAddressType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IPAddressType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipAddressType = mapped
    }

    /**
     * @param value The IP address type of this frontend configuration. If omitted the default value is IPv4.
     */
    @JvmName("rohpefmgqffphail")
    public fun ipAddressType(`value`: IPAddressType) {
        val toBeMapped = Either.ofRight<String, IPAddressType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipAddressType = mapped
    }

    /**
     * @param value The resource Id of the Load Balancer backend address pool that the VM instances of the node type are associated with. The format of the resource Id is '/subscriptions/<subscriptionId>/resourceGroups/<resourceGroupName>/providers/Microsoft.Network/loadBalancers/<loadBalancerName>/backendAddressPools/<backendAddressPoolName>'.
     */
    @JvmName("glbstiglfycqpbde")
    public suspend fun loadBalancerBackendAddressPoolId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerBackendAddressPoolId = mapped
    }

    /**
     * @param value The resource Id of the Load Balancer inbound NAT pool that the VM instances of the node type are associated with. The format of the resource Id is '/subscriptions/<subscriptionId>/resourceGroups/<resourceGroupName>/providers/Microsoft.Network/loadBalancers/<loadBalancerName>/inboundNatPools/<inboundNatPoolName>'.
     */
    @JvmName("uevnhsfcounreyrj")
    public suspend fun loadBalancerInboundNatPoolId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerInboundNatPoolId = mapped
    }

    internal fun build(): FrontendConfigurationArgs = FrontendConfigurationArgs(
        applicationGatewayBackendAddressPoolId = applicationGatewayBackendAddressPoolId,
        ipAddressType = ipAddressType,
        loadBalancerBackendAddressPoolId = loadBalancerBackendAddressPoolId,
        loadBalancerInboundNatPoolId = loadBalancerInboundNatPoolId,
    )
}
