@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.inputs

import com.pulumi.azurenative.servicefabric.inputs.GetmanagedMaintenanceWindowStatusPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property clusterName The name of the cluster resource.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetmanagedMaintenanceWindowStatusPlainArgs(
    public val clusterName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.servicefabric.inputs.GetmanagedMaintenanceWindowStatusPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.servicefabric.inputs.GetmanagedMaintenanceWindowStatusPlainArgs =
        com.pulumi.azurenative.servicefabric.inputs.GetmanagedMaintenanceWindowStatusPlainArgs.builder()
            .clusterName(clusterName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetmanagedMaintenanceWindowStatusPlainArgs].
 */
@PulumiTagMarker
public class GetmanagedMaintenanceWindowStatusPlainArgsBuilder internal constructor() {
    private var clusterName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the cluster resource.
     */
    @JvmName("qsbohchswlsvtfff")
    public suspend fun clusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ltabfedfkmmxtabg")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetmanagedMaintenanceWindowStatusPlainArgs =
        GetmanagedMaintenanceWindowStatusPlainArgs(
            clusterName = clusterName ?: throw PulumiNullFieldException("clusterName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
