@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.inputs

import com.pulumi.azurenative.servicefabric.inputs.ServiceTypeHealthPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represents the health policy used to evaluate the health of services belonging to a service type.
 * @property maxPercentUnhealthyPartitionsPerService The maximum allowed percentage of unhealthy partitions per service.
 * The percentage represents the maximum tolerated percentage of partitions that can be unhealthy before the service is considered in error.
 * If the percentage is respected but there is at least one unhealthy partition, the health is evaluated as Warning.
 * The percentage is calculated by dividing the number of unhealthy partitions over the total number of partitions in the service.
 * The computation rounds up to tolerate one failure on small numbers of partitions.
 * @property maxPercentUnhealthyReplicasPerPartition The maximum allowed percentage of unhealthy replicas per partition.
 * The percentage represents the maximum tolerated percentage of replicas that can be unhealthy before the partition is considered in error.
 * If the percentage is respected but there is at least one unhealthy replica, the health is evaluated as Warning.
 * The percentage is calculated by dividing the number of unhealthy replicas over the total number of replicas in the partition.
 * The computation rounds up to tolerate one failure on small numbers of replicas.
 * @property maxPercentUnhealthyServices The maximum allowed percentage of unhealthy services.
 * The percentage represents the maximum tolerated percentage of services that can be unhealthy before the application is considered in error.
 * If the percentage is respected but there is at least one unhealthy service, the health is evaluated as Warning.
 * This is calculated by dividing the number of unhealthy services of the specific service type over the total number of services of the specific service type.
 * The computation rounds up to tolerate one failure on small numbers of services.
 */
public data class ServiceTypeHealthPolicyArgs(
    public val maxPercentUnhealthyPartitionsPerService: Output<Int>,
    public val maxPercentUnhealthyReplicasPerPartition: Output<Int>,
    public val maxPercentUnhealthyServices: Output<Int>,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabric.inputs.ServiceTypeHealthPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabric.inputs.ServiceTypeHealthPolicyArgs =
        com.pulumi.azurenative.servicefabric.inputs.ServiceTypeHealthPolicyArgs.builder()
            .maxPercentUnhealthyPartitionsPerService(
                maxPercentUnhealthyPartitionsPerService.applyValue({ args0 ->
                    args0
                }),
            )
            .maxPercentUnhealthyReplicasPerPartition(
                maxPercentUnhealthyReplicasPerPartition.applyValue({ args0 ->
                    args0
                }),
            )
            .maxPercentUnhealthyServices(maxPercentUnhealthyServices.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceTypeHealthPolicyArgs].
 */
@PulumiTagMarker
public class ServiceTypeHealthPolicyArgsBuilder internal constructor() {
    private var maxPercentUnhealthyPartitionsPerService: Output<Int>? = null

    private var maxPercentUnhealthyReplicasPerPartition: Output<Int>? = null

    private var maxPercentUnhealthyServices: Output<Int>? = null

    /**
     * @param value The maximum allowed percentage of unhealthy partitions per service.
     * The percentage represents the maximum tolerated percentage of partitions that can be unhealthy before the service is considered in error.
     * If the percentage is respected but there is at least one unhealthy partition, the health is evaluated as Warning.
     * The percentage is calculated by dividing the number of unhealthy partitions over the total number of partitions in the service.
     * The computation rounds up to tolerate one failure on small numbers of partitions.
     */
    @JvmName("vnquxqymsgjxqbai")
    public suspend fun maxPercentUnhealthyPartitionsPerService(`value`: Output<Int>) {
        this.maxPercentUnhealthyPartitionsPerService = value
    }

    /**
     * @param value The maximum allowed percentage of unhealthy replicas per partition.
     * The percentage represents the maximum tolerated percentage of replicas that can be unhealthy before the partition is considered in error.
     * If the percentage is respected but there is at least one unhealthy replica, the health is evaluated as Warning.
     * The percentage is calculated by dividing the number of unhealthy replicas over the total number of replicas in the partition.
     * The computation rounds up to tolerate one failure on small numbers of replicas.
     */
    @JvmName("btjgutemnkxtlawx")
    public suspend fun maxPercentUnhealthyReplicasPerPartition(`value`: Output<Int>) {
        this.maxPercentUnhealthyReplicasPerPartition = value
    }

    /**
     * @param value The maximum allowed percentage of unhealthy services.
     * The percentage represents the maximum tolerated percentage of services that can be unhealthy before the application is considered in error.
     * If the percentage is respected but there is at least one unhealthy service, the health is evaluated as Warning.
     * This is calculated by dividing the number of unhealthy services of the specific service type over the total number of services of the specific service type.
     * The computation rounds up to tolerate one failure on small numbers of services.
     */
    @JvmName("nlinhfxpeqsauurn")
    public suspend fun maxPercentUnhealthyServices(`value`: Output<Int>) {
        this.maxPercentUnhealthyServices = value
    }

    /**
     * @param value The maximum allowed percentage of unhealthy partitions per service.
     * The percentage represents the maximum tolerated percentage of partitions that can be unhealthy before the service is considered in error.
     * If the percentage is respected but there is at least one unhealthy partition, the health is evaluated as Warning.
     * The percentage is calculated by dividing the number of unhealthy partitions over the total number of partitions in the service.
     * The computation rounds up to tolerate one failure on small numbers of partitions.
     */
    @JvmName("yannfeqqcpqcemen")
    public suspend fun maxPercentUnhealthyPartitionsPerService(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxPercentUnhealthyPartitionsPerService = mapped
    }

    /**
     * @param value The maximum allowed percentage of unhealthy replicas per partition.
     * The percentage represents the maximum tolerated percentage of replicas that can be unhealthy before the partition is considered in error.
     * If the percentage is respected but there is at least one unhealthy replica, the health is evaluated as Warning.
     * The percentage is calculated by dividing the number of unhealthy replicas over the total number of replicas in the partition.
     * The computation rounds up to tolerate one failure on small numbers of replicas.
     */
    @JvmName("xuooogrmciqtylum")
    public suspend fun maxPercentUnhealthyReplicasPerPartition(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxPercentUnhealthyReplicasPerPartition = mapped
    }

    /**
     * @param value The maximum allowed percentage of unhealthy services.
     * The percentage represents the maximum tolerated percentage of services that can be unhealthy before the application is considered in error.
     * If the percentage is respected but there is at least one unhealthy service, the health is evaluated as Warning.
     * This is calculated by dividing the number of unhealthy services of the specific service type over the total number of services of the specific service type.
     * The computation rounds up to tolerate one failure on small numbers of services.
     */
    @JvmName("rkvnwjknduketlct")
    public suspend fun maxPercentUnhealthyServices(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxPercentUnhealthyServices = mapped
    }

    internal fun build(): ServiceTypeHealthPolicyArgs = ServiceTypeHealthPolicyArgs(
        maxPercentUnhealthyPartitionsPerService = maxPercentUnhealthyPartitionsPerService ?: throw
            PulumiNullFieldException("maxPercentUnhealthyPartitionsPerService"),
        maxPercentUnhealthyReplicasPerPartition = maxPercentUnhealthyReplicasPerPartition ?: throw
            PulumiNullFieldException("maxPercentUnhealthyReplicasPerPartition"),
        maxPercentUnhealthyServices = maxPercentUnhealthyServices ?: throw
            PulumiNullFieldException("maxPercentUnhealthyServices"),
    )
}
