@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.inputs

import com.pulumi.azurenative.servicefabric.inputs.SettingsSectionDescriptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes a section in the fabric settings of the cluster.
 * @property name The section name of the fabric settings.
 * @property parameters The collection of parameters in the section.
 */
public data class SettingsSectionDescriptionArgs(
    public val name: Output<String>,
    public val parameters: Output<List<SettingsParameterDescriptionArgs>>,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabric.inputs.SettingsSectionDescriptionArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabric.inputs.SettingsSectionDescriptionArgs =
        com.pulumi.azurenative.servicefabric.inputs.SettingsSectionDescriptionArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .parameters(
                parameters.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [SettingsSectionDescriptionArgs].
 */
@PulumiTagMarker
public class SettingsSectionDescriptionArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var parameters: Output<List<SettingsParameterDescriptionArgs>>? = null

    /**
     * @param value The section name of the fabric settings.
     */
    @JvmName("ieylsvllghikuimf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The collection of parameters in the section.
     */
    @JvmName("tlxrvtsxixngwykn")
    public suspend fun parameters(`value`: Output<List<SettingsParameterDescriptionArgs>>) {
        this.parameters = value
    }

    @JvmName("jbsvbrlygftbiovf")
    public suspend fun parameters(vararg values: Output<SettingsParameterDescriptionArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values The collection of parameters in the section.
     */
    @JvmName("rrvrtbnntyikeufr")
    public suspend fun parameters(values: List<Output<SettingsParameterDescriptionArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value The section name of the fabric settings.
     */
    @JvmName("lvlhqwjgojdkhqxr")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The collection of parameters in the section.
     */
    @JvmName("stewfvgajhqwmxfn")
    public suspend fun parameters(`value`: List<SettingsParameterDescriptionArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument The collection of parameters in the section.
     */
    @JvmName("jbrfouwwmgtcrevi")
    public suspend
    fun parameters(argument: List<suspend SettingsParameterDescriptionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SettingsParameterDescriptionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument The collection of parameters in the section.
     */
    @JvmName("lyymgeiouyccogmg")
    public suspend fun parameters(
        vararg
        argument: suspend SettingsParameterDescriptionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            SettingsParameterDescriptionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument The collection of parameters in the section.
     */
    @JvmName("ftcdpjwfbswmfyyk")
    public suspend
    fun parameters(argument: suspend SettingsParameterDescriptionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            SettingsParameterDescriptionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values The collection of parameters in the section.
     */
    @JvmName("sngpejmkxtfhttxw")
    public suspend fun parameters(vararg values: SettingsParameterDescriptionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    internal fun build(): SettingsSectionDescriptionArgs = SettingsSectionDescriptionArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        parameters = parameters ?: throw PulumiNullFieldException("parameters"),
    )
}
