@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.inputs

import com.pulumi.azurenative.servicefabric.inputs.VMSSExtensionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Specifies set of extensions that should be installed onto the virtual machines.
 * @property autoUpgradeMinorVersion Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
 * @property enableAutomaticUpgrade Indicates whether the extension should be automatically upgraded by the platform if there is a newer version of the extension available.
 * @property forceUpdateTag If a value is provided and is different from the previous value, the extension handler will be forced to update even if the extension configuration has not changed.
 * @property name The name of the extension.
 * @property protectedSettings The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
 * @property provisionAfterExtensions Collection of extension names after which this extension needs to be provisioned.
 * @property publisher The name of the extension handler publisher.
 * @property settings Json formatted public settings for the extension.
 * @property type Specifies the type of the extension; an example is "CustomScriptExtension".
 * @property typeHandlerVersion Specifies the version of the script handler.
 */
public data class VMSSExtensionArgs(
    public val autoUpgradeMinorVersion: Output<Boolean>? = null,
    public val enableAutomaticUpgrade: Output<Boolean>? = null,
    public val forceUpdateTag: Output<String>? = null,
    public val name: Output<String>,
    public val protectedSettings: Output<Any>? = null,
    public val provisionAfterExtensions: Output<List<String>>? = null,
    public val publisher: Output<String>,
    public val settings: Output<Any>? = null,
    public val type: Output<String>,
    public val typeHandlerVersion: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabric.inputs.VMSSExtensionArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabric.inputs.VMSSExtensionArgs =
        com.pulumi.azurenative.servicefabric.inputs.VMSSExtensionArgs.builder()
            .autoUpgradeMinorVersion(autoUpgradeMinorVersion?.applyValue({ args0 -> args0 }))
            .enableAutomaticUpgrade(enableAutomaticUpgrade?.applyValue({ args0 -> args0 }))
            .forceUpdateTag(forceUpdateTag?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .protectedSettings(protectedSettings?.applyValue({ args0 -> args0 }))
            .provisionAfterExtensions(
                provisionAfterExtensions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .publisher(publisher.applyValue({ args0 -> args0 }))
            .settings(settings?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .typeHandlerVersion(typeHandlerVersion.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VMSSExtensionArgs].
 */
@PulumiTagMarker
public class VMSSExtensionArgsBuilder internal constructor() {
    private var autoUpgradeMinorVersion: Output<Boolean>? = null

    private var enableAutomaticUpgrade: Output<Boolean>? = null

    private var forceUpdateTag: Output<String>? = null

    private var name: Output<String>? = null

    private var protectedSettings: Output<Any>? = null

    private var provisionAfterExtensions: Output<List<String>>? = null

    private var publisher: Output<String>? = null

    private var settings: Output<Any>? = null

    private var type: Output<String>? = null

    private var typeHandlerVersion: Output<String>? = null

    /**
     * @param value Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
     */
    @JvmName("vkitwaqhclhlmfju")
    public suspend fun autoUpgradeMinorVersion(`value`: Output<Boolean>) {
        this.autoUpgradeMinorVersion = value
    }

    /**
     * @param value Indicates whether the extension should be automatically upgraded by the platform if there is a newer version of the extension available.
     */
    @JvmName("xedjveocxssvmpwe")
    public suspend fun enableAutomaticUpgrade(`value`: Output<Boolean>) {
        this.enableAutomaticUpgrade = value
    }

    /**
     * @param value If a value is provided and is different from the previous value, the extension handler will be forced to update even if the extension configuration has not changed.
     */
    @JvmName("rryuvtllkfseaxgh")
    public suspend fun forceUpdateTag(`value`: Output<String>) {
        this.forceUpdateTag = value
    }

    /**
     * @param value The name of the extension.
     */
    @JvmName("vxolejbtmgkwlhxw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
     */
    @JvmName("kxnieqkjrlnyodjh")
    public suspend fun protectedSettings(`value`: Output<Any>) {
        this.protectedSettings = value
    }

    /**
     * @param value Collection of extension names after which this extension needs to be provisioned.
     */
    @JvmName("bqncfpahgbyygvsh")
    public suspend fun provisionAfterExtensions(`value`: Output<List<String>>) {
        this.provisionAfterExtensions = value
    }

    @JvmName("flyoaesrlqetpenw")
    public suspend fun provisionAfterExtensions(vararg values: Output<String>) {
        this.provisionAfterExtensions = Output.all(values.asList())
    }

    /**
     * @param values Collection of extension names after which this extension needs to be provisioned.
     */
    @JvmName("mrpsilacceykfxav")
    public suspend fun provisionAfterExtensions(values: List<Output<String>>) {
        this.provisionAfterExtensions = Output.all(values)
    }

    /**
     * @param value The name of the extension handler publisher.
     */
    @JvmName("cjmkdispniskatnv")
    public suspend fun publisher(`value`: Output<String>) {
        this.publisher = value
    }

    /**
     * @param value Json formatted public settings for the extension.
     */
    @JvmName("iqfrkiahihfrfyyn")
    public suspend fun settings(`value`: Output<Any>) {
        this.settings = value
    }

    /**
     * @param value Specifies the type of the extension; an example is "CustomScriptExtension".
     */
    @JvmName("hnrwhcuycdkvbyyd")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Specifies the version of the script handler.
     */
    @JvmName("avksknxkxxysuwph")
    public suspend fun typeHandlerVersion(`value`: Output<String>) {
        this.typeHandlerVersion = value
    }

    /**
     * @param value Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
     */
    @JvmName("mpyreisjagpovxav")
    public suspend fun autoUpgradeMinorVersion(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoUpgradeMinorVersion = mapped
    }

    /**
     * @param value Indicates whether the extension should be automatically upgraded by the platform if there is a newer version of the extension available.
     */
    @JvmName("cavwwrxesrvbivba")
    public suspend fun enableAutomaticUpgrade(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableAutomaticUpgrade = mapped
    }

    /**
     * @param value If a value is provided and is different from the previous value, the extension handler will be forced to update even if the extension configuration has not changed.
     */
    @JvmName("pmifthphveekwnbg")
    public suspend fun forceUpdateTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceUpdateTag = mapped
    }

    /**
     * @param value The name of the extension.
     */
    @JvmName("gdyyoklpebgearst")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
     */
    @JvmName("ktigsxjynockbpjn")
    public suspend fun protectedSettings(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectedSettings = mapped
    }

    /**
     * @param value Collection of extension names after which this extension needs to be provisioned.
     */
    @JvmName("mpbtmxggsmtvpmmo")
    public suspend fun provisionAfterExtensions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisionAfterExtensions = mapped
    }

    /**
     * @param values Collection of extension names after which this extension needs to be provisioned.
     */
    @JvmName("lrmgxxckeijwytpx")
    public suspend fun provisionAfterExtensions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisionAfterExtensions = mapped
    }

    /**
     * @param value The name of the extension handler publisher.
     */
    @JvmName("donqvvnknrvwahwg")
    public suspend fun publisher(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publisher = mapped
    }

    /**
     * @param value Json formatted public settings for the extension.
     */
    @JvmName("wxuwiatrreyjpvdy")
    public suspend fun settings(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.settings = mapped
    }

    /**
     * @param value Specifies the type of the extension; an example is "CustomScriptExtension".
     */
    @JvmName("rfcyumbiaddxtrvx")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Specifies the version of the script handler.
     */
    @JvmName("hpxmgkurdcgbfhhv")
    public suspend fun typeHandlerVersion(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.typeHandlerVersion = mapped
    }

    internal fun build(): VMSSExtensionArgs = VMSSExtensionArgs(
        autoUpgradeMinorVersion = autoUpgradeMinorVersion,
        enableAutomaticUpgrade = enableAutomaticUpgrade,
        forceUpdateTag = forceUpdateTag,
        name = name ?: throw PulumiNullFieldException("name"),
        protectedSettings = protectedSettings,
        provisionAfterExtensions = provisionAfterExtensions,
        publisher = publisher ?: throw PulumiNullFieldException("publisher"),
        settings = settings,
        type = type ?: throw PulumiNullFieldException("type"),
        typeHandlerVersion = typeHandlerVersion ?: throw PulumiNullFieldException("typeHandlerVersion"),
    )
}
