@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The application resource.
 * @property id Azure resource identifier.
 * @property identity Describes the managed identities for an Azure resource.
 * @property location Resource location depends on the parent resource.
 * @property managedIdentities List of user assigned identities for the application, each mapped to a friendly name.
 * @property name Azure resource name.
 * @property parameters List of application parameters with overridden values from their default values specified in the application manifest.
 * @property provisioningState The current deployment or provisioning state, which only appears in the response
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property tags Azure resource tags.
 * @property type Azure resource type.
 * @property upgradePolicy Describes the policy for a monitored application upgrade.
 * @property version The version of the application type as defined in the application manifest.
 * This name must be the full Arm Resource ID for the referenced application type version.
 */
public data class GetManagedClusterApplicationResult(
    public val id: String,
    public val identity: ManagedIdentityResponse? = null,
    public val location: String? = null,
    public val managedIdentities: List<ApplicationUserAssignedIdentityResponse>? = null,
    public val name: String,
    public val parameters: Map<String, String>? = null,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val upgradePolicy: ApplicationUpgradePolicyResponse? = null,
    public val version: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.outputs.GetManagedClusterApplicationResult):
            GetManagedClusterApplicationResult = GetManagedClusterApplicationResult(
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabric.kotlin.outputs.ManagedIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            managedIdentities = javaType.managedIdentities().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabric.kotlin.outputs.ApplicationUserAssignedIdentityResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            parameters = javaType.parameters().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.servicefabric.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            upgradePolicy = javaType.upgradePolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabric.kotlin.outputs.ApplicationUpgradePolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
