@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The managed cluster resource
 * @property addonFeatures List of add-on features to enable on the cluster.
 * @property adminPassword VM admin user password.
 * @property adminUserName VM admin user name.
 * @property allowRdpAccess Setting this to true enables RDP access to the VM. The default NSG rule opens RDP port to Internet which can be overridden with custom Network Security Rules. The default value for this setting is false.
 * @property applicationTypeVersionsCleanupPolicy The policy used to clean up unused versions.
 * @property auxiliarySubnets Auxiliary subnets for the cluster.
 * @property azureActiveDirectory The AAD authentication settings of the cluster.
 * @property clientConnectionPort The port used for client connections to the cluster.
 * @property clients Client certificates that are allowed to manage the cluster.
 * @property clusterCertificateThumbprints List of thumbprints of the cluster certificates.
 * @property clusterCodeVersion The Service Fabric runtime version of the cluster. This property is required when **clusterUpgradeMode** is set to 'Manual'. To get list of available Service Fabric versions for new clusters use [ClusterVersion API](./ClusterVersion.md). To get the list of available version for existing clusters use **availableClusterVersions**.
 * @property clusterId A service generated unique identifier for the cluster resource.
 * @property clusterState The current state of the cluster.
 * @property clusterUpgradeCadence Indicates when new cluster runtime version upgrades will be applied after they are released. By default is Wave0. Only applies when **clusterUpgradeMode** is set to 'Automatic'.
 * @property clusterUpgradeMode The upgrade mode of the cluster when new Service Fabric runtime version is available.
 * @property dnsName The cluster dns name.
 * @property enableAutoOSUpgrade Setting this to true enables automatic OS upgrade for the node types that are created using any platform OS image with version 'latest'. The default value for this setting is false.
 * @property enableIpv6 Setting this to true creates IPv6 address space for the default VNet used by the cluster. This setting cannot be changed once the cluster is created. The default value for this setting is false.
 * @property enableServicePublicIP Setting this to true will link the IPv4 address as the ServicePublicIP of the IPv6 address. It can only be set to True if IPv6 is enabled on the cluster.
 * @property etag Azure resource etag.
 * @property fabricSettings The list of custom fabric settings to configure the cluster.
 * @property fqdn The fully qualified domain name associated with the public load balancer of the cluster.
 * @property httpGatewayConnectionPort The port used for HTTP connections to the cluster.
 * @property id Azure resource identifier.
 * @property ipTags The list of IP tags associated with the default public IP address of the cluster.
 * @property ipv4Address The IPv4 address associated with the public load balancer of the cluster.
 * @property ipv6Address IPv6 address for the cluster if IPv6 is enabled.
 * @property loadBalancingRules Load balancing rules that are applied to the public load balancer of the cluster.
 * @property location Azure resource location.
 * @property name Azure resource name.
 * @property networkSecurityRules Custom Network Security Rules that are applied to the Virtual Network of the cluster.
 * @property provisioningState The provisioning state of the managed cluster resource.
 * @property publicIPPrefixId Specify the resource id of a public IP prefix that the load balancer will allocate a public IP address from. Only supports IPv4.
 * @property serviceEndpoints Service endpoints for subnets in the cluster.
 * @property sku The sku of the managed cluster
 * @property subnetId If specified, the node types for the cluster are created in this subnet instead of the default VNet. The **networkSecurityRules** specified for the cluster are also applied to this subnet. This setting cannot be changed once the cluster is created.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property tags Azure resource tags.
 * @property type Azure resource type.
 * @property useCustomVnet For new clusters, this parameter indicates that it uses Bring your own VNet, but the subnet is specified at node type level; and for such clusters, the subnetId property is required for node types.
 * @property zonalResiliency Indicates if the cluster has zone resiliency.
 * @property zonalUpdateMode Indicates the update mode for Cross Az clusters.
 */
public data class GetManagedClusterResult(
    public val addonFeatures: List<String>? = null,
    public val adminPassword: String? = null,
    public val adminUserName: String,
    public val allowRdpAccess: Boolean? = null,
    public val applicationTypeVersionsCleanupPolicy: ApplicationTypeVersionsCleanupPolicyResponse? =
        null,
    public val auxiliarySubnets: List<SubnetResponse>? = null,
    public val azureActiveDirectory: AzureActiveDirectoryResponse? = null,
    public val clientConnectionPort: Int? = null,
    public val clients: List<ClientCertificateResponse>? = null,
    public val clusterCertificateThumbprints: List<String>,
    public val clusterCodeVersion: String? = null,
    public val clusterId: String,
    public val clusterState: String,
    public val clusterUpgradeCadence: String? = null,
    public val clusterUpgradeMode: String? = null,
    public val dnsName: String,
    public val enableAutoOSUpgrade: Boolean? = null,
    public val enableIpv6: Boolean? = null,
    public val enableServicePublicIP: Boolean? = null,
    public val etag: String,
    public val fabricSettings: List<SettingsSectionDescriptionResponse>? = null,
    public val fqdn: String,
    public val httpGatewayConnectionPort: Int? = null,
    public val id: String,
    public val ipTags: List<IPTagResponse>? = null,
    public val ipv4Address: String,
    public val ipv6Address: String,
    public val loadBalancingRules: List<LoadBalancingRuleResponse>? = null,
    public val location: String,
    public val name: String,
    public val networkSecurityRules: List<NetworkSecurityRuleResponse>? = null,
    public val provisioningState: String,
    public val publicIPPrefixId: String? = null,
    public val serviceEndpoints: List<ServiceEndpointResponse>? = null,
    public val sku: SkuResponse,
    public val subnetId: String? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val useCustomVnet: Boolean? = null,
    public val zonalResiliency: Boolean? = null,
    public val zonalUpdateMode: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.outputs.GetManagedClusterResult):
            GetManagedClusterResult = GetManagedClusterResult(
            addonFeatures = javaType.addonFeatures().map({ args0 -> args0 }),
            adminPassword = javaType.adminPassword().map({ args0 -> args0 }).orElse(null),
            adminUserName = javaType.adminUserName(),
            allowRdpAccess = javaType.allowRdpAccess().map({ args0 -> args0 }).orElse(null),
            applicationTypeVersionsCleanupPolicy = javaType.applicationTypeVersionsCleanupPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabric.kotlin.outputs.ApplicationTypeVersionsCleanupPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            auxiliarySubnets = javaType.auxiliarySubnets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabric.kotlin.outputs.SubnetResponse.Companion.toKotlin(args0)
                })
            }),
            azureActiveDirectory = javaType.azureActiveDirectory().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabric.kotlin.outputs.AzureActiveDirectoryResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            clientConnectionPort = javaType.clientConnectionPort().map({ args0 -> args0 }).orElse(null),
            clients = javaType.clients().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabric.kotlin.outputs.ClientCertificateResponse.Companion.toKotlin(args0)
                })
            }),
            clusterCertificateThumbprints = javaType.clusterCertificateThumbprints().map({ args0 -> args0 }),
            clusterCodeVersion = javaType.clusterCodeVersion().map({ args0 -> args0 }).orElse(null),
            clusterId = javaType.clusterId(),
            clusterState = javaType.clusterState(),
            clusterUpgradeCadence = javaType.clusterUpgradeCadence().map({ args0 -> args0 }).orElse(null),
            clusterUpgradeMode = javaType.clusterUpgradeMode().map({ args0 -> args0 }).orElse(null),
            dnsName = javaType.dnsName(),
            enableAutoOSUpgrade = javaType.enableAutoOSUpgrade().map({ args0 -> args0 }).orElse(null),
            enableIpv6 = javaType.enableIpv6().map({ args0 -> args0 }).orElse(null),
            enableServicePublicIP = javaType.enableServicePublicIP().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            fabricSettings = javaType.fabricSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabric.kotlin.outputs.SettingsSectionDescriptionResponse.Companion.toKotlin(args0)
                })
            }),
            fqdn = javaType.fqdn(),
            httpGatewayConnectionPort = javaType.httpGatewayConnectionPort().map({ args0 ->
                args0
            }).orElse(null),
            id = javaType.id(),
            ipTags = javaType.ipTags().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabric.kotlin.outputs.IPTagResponse.Companion.toKotlin(args0)
                })
            }),
            ipv4Address = javaType.ipv4Address(),
            ipv6Address = javaType.ipv6Address(),
            loadBalancingRules = javaType.loadBalancingRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabric.kotlin.outputs.LoadBalancingRuleResponse.Companion.toKotlin(args0)
                })
            }),
            location = javaType.location(),
            name = javaType.name(),
            networkSecurityRules = javaType.networkSecurityRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabric.kotlin.outputs.NetworkSecurityRuleResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            publicIPPrefixId = javaType.publicIPPrefixId().map({ args0 -> args0 }).orElse(null),
            serviceEndpoints = javaType.serviceEndpoints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabric.kotlin.outputs.ServiceEndpointResponse.Companion.toKotlin(args0)
                })
            }),
            sku = javaType.sku().let({ args0 ->
                com.pulumi.azurenative.servicefabric.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
            }),
            subnetId = javaType.subnetId().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.servicefabric.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            useCustomVnet = javaType.useCustomVnet().map({ args0 -> args0 }).orElse(null),
            zonalResiliency = javaType.zonalResiliency().map({ args0 -> args0 }).orElse(null),
            zonalUpdateMode = javaType.zonalUpdateMode().map({ args0 -> args0 }).orElse(null),
        )
    }
}
