@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Suppress

/**
 * Specifies a metric to load balance a service during runtime.
 * @property scalingMechanism Specifies the mechanism associated with this scaling policy
 * @property scalingTrigger Specifies the trigger associated with this scaling policy.
 */
public data class ScalingPolicyResponse(
    public val scalingMechanism:
    Either<AddRemoveIncrementalNamedPartitionScalingMechanismResponse, PartitionInstanceCountScaleMechanismResponse>,
    public val scalingTrigger:
    Either<AveragePartitionLoadScalingTriggerResponse, AverageServiceLoadScalingTriggerResponse>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.outputs.ScalingPolicyResponse):
            ScalingPolicyResponse = ScalingPolicyResponse(
            scalingMechanism = javaType.scalingMechanism().transform(
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.servicefabric.kotlin.outputs.AddRemoveIncrementalNamedPartitionScalingMechanismResponse.Companion.toKotlin(args0)
                    })
                },
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.servicefabric.kotlin.outputs.PartitionInstanceCountScaleMechanismResponse.Companion.toKotlin(args0)
                    })
                },
            ),
            scalingTrigger = javaType.scalingTrigger().transform(
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.servicefabric.kotlin.outputs.AveragePartitionLoadScalingTriggerResponse.Companion.toKotlin(args0)
                    })
                },
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.servicefabric.kotlin.outputs.AverageServiceLoadScalingTriggerResponse.Companion.toKotlin(args0)
                    })
                },
            ),
        )
    }
}
