@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * Represents the health policy used to evaluate the health of services belonging to a service type.
 * @property maxPercentUnhealthyPartitionsPerService The maximum allowed percentage of unhealthy partitions per service.
 * The percentage represents the maximum tolerated percentage of partitions that can be unhealthy before the service is considered in error.
 * If the percentage is respected but there is at least one unhealthy partition, the health is evaluated as Warning.
 * The percentage is calculated by dividing the number of unhealthy partitions over the total number of partitions in the service.
 * The computation rounds up to tolerate one failure on small numbers of partitions.
 * @property maxPercentUnhealthyReplicasPerPartition The maximum allowed percentage of unhealthy replicas per partition.
 * The percentage represents the maximum tolerated percentage of replicas that can be unhealthy before the partition is considered in error.
 * If the percentage is respected but there is at least one unhealthy replica, the health is evaluated as Warning.
 * The percentage is calculated by dividing the number of unhealthy replicas over the total number of replicas in the partition.
 * The computation rounds up to tolerate one failure on small numbers of replicas.
 * @property maxPercentUnhealthyServices The maximum allowed percentage of unhealthy services.
 * The percentage represents the maximum tolerated percentage of services that can be unhealthy before the application is considered in error.
 * If the percentage is respected but there is at least one unhealthy service, the health is evaluated as Warning.
 * This is calculated by dividing the number of unhealthy services of the specific service type over the total number of services of the specific service type.
 * The computation rounds up to tolerate one failure on small numbers of services.
 */
public data class ServiceTypeHealthPolicyResponse(
    public val maxPercentUnhealthyPartitionsPerService: Int,
    public val maxPercentUnhealthyReplicasPerPartition: Int,
    public val maxPercentUnhealthyServices: Int,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.outputs.ServiceTypeHealthPolicyResponse):
            ServiceTypeHealthPolicyResponse = ServiceTypeHealthPolicyResponse(
            maxPercentUnhealthyPartitionsPerService = javaType.maxPercentUnhealthyPartitionsPerService(),
            maxPercentUnhealthyReplicasPerPartition = javaType.maxPercentUnhealthyReplicasPerPartition(),
            maxPercentUnhealthyServices = javaType.maxPercentUnhealthyServices(),
        )
    }
}
