@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Identities for the virtual machine scale set under the node type.
 * @property userAssignedIdentities The list of user identities associated with the virtual machine scale set under the node type. Each entry will be an ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
 */
public data class VmManagedIdentityResponse(
    public val userAssignedIdentities: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.outputs.VmManagedIdentityResponse):
            VmManagedIdentityResponse = VmManagedIdentityResponse(
            userAssignedIdentities = javaType.userAssignedIdentities().map({ args0 -> args0 }),
        )
    }
}
