@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin

import com.pulumi.azurenative.servicefabricmesh.ApplicationArgs.builder
import com.pulumi.azurenative.servicefabricmesh.kotlin.inputs.DiagnosticsDescriptionArgs
import com.pulumi.azurenative.servicefabricmesh.kotlin.inputs.DiagnosticsDescriptionArgsBuilder
import com.pulumi.azurenative.servicefabricmesh.kotlin.inputs.ServiceResourceDescriptionArgs
import com.pulumi.azurenative.servicefabricmesh.kotlin.inputs.ServiceResourceDescriptionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * This type describes an application resource.
 * Azure REST API version: 2018-09-01-preview. Prior API version in Azure Native 1.x: 2018-09-01-preview.
 * Other available API versions: 2018-07-01-preview.
 * ## Example Usage
 * ### CreateOrUpdateApplication
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var application = new AzureNative.ServiceFabricMesh.Application("application", new()
 *     {
 *         ApplicationResourceName = "sampleApplication",
 *         Description = "Service Fabric Mesh sample application.",
 *         Location = "EastUS",
 *         ResourceGroupName = "sbz_demo",
 *         Services = new[]
 *         {
 *             new AzureNative.ServiceFabricMesh.Inputs.ServiceResourceDescriptionArgs
 *             {
 *                 CodePackages = new[]
 *                 {
 *                     new AzureNative.ServiceFabricMesh.Inputs.ContainerCodePackagePropertiesArgs
 *                     {
 *                         Endpoints = new[]
 *                         {
 *                             new AzureNative.ServiceFabricMesh.Inputs.EndpointPropertiesArgs
 *                             {
 *                                 Name = "helloWorldListener",
 *                                 Port = 80,
 *                             },
 *                         },
 *                         Image = "seabreeze/sbz-helloworld:1.0-alpine",
 *                         Name = "helloWorldCode",
 *                         Resources = new AzureNative.ServiceFabricMesh.Inputs.ResourceRequirementsArgs
 *                         {
 *                             Requests = new AzureNative.ServiceFabricMesh.Inputs.ResourceRequestsArgs
 *                             {
 *                                 Cpu = 1,
 *                                 MemoryInGB = 1,
 *                             },
 *                         },
 *                     },
 *                 },
 *                 Description = "SeaBreeze Hello World Service.",
 *                 Name = "helloWorldService",
 *                 NetworkRefs = new[]
 *                 {
 *                     new AzureNative.ServiceFabricMesh.Inputs.NetworkRefArgs
 *                     {
 *                         EndpointRefs = new[]
 *                         {
 *                             new AzureNative.ServiceFabricMesh.Inputs.EndpointRefArgs
 *                             {
 *                                 Name = "helloWorldListener",
 *                             },
 *                         },
 *                         Name = "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/sbz_demo/providers/Microsoft.ServiceFabricMesh/networks/sampleNetwork",
 *                     },
 *                 },
 *                 OsType = "Linux",
 *                 ReplicaCount = 1,
 *             },
 *         },
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicefabricmesh/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicefabricmesh.NewApplication(ctx, "application", &servicefabricmesh.ApplicationArgs{
 * 			ApplicationResourceName: pulumi.String("sampleApplication"),
 * 			Description:             pulumi.String("Service Fabric Mesh sample application."),
 * 			Location:                pulumi.String("EastUS"),
 * 			ResourceGroupName:       pulumi.String("sbz_demo"),
 * 			Services: []servicefabricmesh.ServiceResourceDescriptionArgs{
 * 				{
 * 					CodePackages: []servicefabricmesh.ContainerCodePackagePropertiesArgs{
 * 						{
 * 							Endpoints: servicefabricmesh.EndpointPropertiesArray{
 * 								{
 * 									Name: pulumi.String("helloWorldListener"),
 * 									Port: pulumi.Int(80),
 * 								},
 * 							},
 * 							Image: pulumi.String("seabreeze/sbz-helloworld:1.0-alpine"),
 * 							Name:  pulumi.String("helloWorldCode"),
 * 							Resources: {
 * 								Requests: {
 * 									Cpu:        pulumi.Float64(1),
 * 									MemoryInGB: pulumi.Float64(1),
 * 								},
 * 							},
 * 						},
 * 					},
 * 					Description: pulumi.String("SeaBreeze Hello World Service."),
 * 					Name:        pulumi.String("helloWorldService"),
 * 					NetworkRefs: servicefabricmesh.NetworkRefArray{
 * 						{
 * 							EndpointRefs: servicefabricmesh.EndpointRefArray{
 * 								{
 * 									Name: pulumi.String("helloWorldListener"),
 * 								},
 * 							},
 * 							Name: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/sbz_demo/providers/Microsoft.ServiceFabricMesh/networks/sampleNetwork"),
 * 						},
 * 					},
 * 					OsType:       pulumi.String("Linux"),
 * 					ReplicaCount: pulumi.Int(1),
 * 				},
 * 			},
 * 			Tags: nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicefabricmesh.Application;
 * import com.pulumi.azurenative.servicefabricmesh.ApplicationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var application = new Application("application", ApplicationArgs.builder()
 *             .applicationResourceName("sampleApplication")
 *             .description("Service Fabric Mesh sample application.")
 *             .location("EastUS")
 *             .resourceGroupName("sbz_demo")
 *             .services(Map.ofEntries(
 *                 Map.entry("codePackages", Map.ofEntries(
 *                     Map.entry("endpoints", Map.ofEntries(
 *                         Map.entry("name", "helloWorldListener"),
 *                         Map.entry("port", 80)
 *                     )),
 *                     Map.entry("image", "seabreeze/sbz-helloworld:1.0-alpine"),
 *                     Map.entry("name", "helloWorldCode"),
 *                     Map.entry("resources", Map.of("requests", Map.ofEntries(
 *                         Map.entry("cpu", 1),
 *                         Map.entry("memoryInGB", 1)
 *                     )))
 *                 )),
 *                 Map.entry("description", "SeaBreeze Hello World Service."),
 *                 Map.entry("name", "helloWorldService"),
 *                 Map.entry("networkRefs", Map.ofEntries(
 *                     Map.entry("endpointRefs", Map.of("name", "helloWorldListener")),
 *                     Map.entry("name", "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/sbz_demo/providers/Microsoft.ServiceFabricMesh/networks/sampleNetwork")
 *                 )),
 *                 Map.entry("osType", "Linux"),
 *                 Map.entry("replicaCount", 1)
 *             ))
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:servicefabricmesh:Application sampleApplication /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceFabricMesh/applications/{applicationResourceName}
 * ```
 * @property applicationResourceName The identity of the application.
 * @property debugParams Internal - used by Visual Studio to setup the debugging session on the local development environment.
 * @property description User readable description of the application.
 * @property diagnostics Describes the diagnostics definition and usage for an application resource.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName Azure resource group name
 * @property services Describes the services in the application. This property is used to create or modify services of the application. On get only the name of the service is returned. The service description can be obtained by querying for the service resource.
 * @property tags Resource tags.
 */
public data class ApplicationArgs(
    public val applicationResourceName: Output<String>? = null,
    public val debugParams: Output<String>? = null,
    public val description: Output<String>? = null,
    public val diagnostics: Output<DiagnosticsDescriptionArgs>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val services: Output<List<ServiceResourceDescriptionArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabricmesh.ApplicationArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabricmesh.ApplicationArgs =
        com.pulumi.azurenative.servicefabricmesh.ApplicationArgs.builder()
            .applicationResourceName(applicationResourceName?.applyValue({ args0 -> args0 }))
            .debugParams(debugParams?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .diagnostics(diagnostics?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .services(
                services?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ApplicationArgs].
 */
@PulumiTagMarker
public class ApplicationArgsBuilder internal constructor() {
    private var applicationResourceName: Output<String>? = null

    private var debugParams: Output<String>? = null

    private var description: Output<String>? = null

    private var diagnostics: Output<DiagnosticsDescriptionArgs>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var services: Output<List<ServiceResourceDescriptionArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The identity of the application.
     */
    @JvmName("xwlhkwwivrctdioy")
    public suspend fun applicationResourceName(`value`: Output<String>) {
        this.applicationResourceName = value
    }

    /**
     * @param value Internal - used by Visual Studio to setup the debugging session on the local development environment.
     */
    @JvmName("cnqcstkedocwxsqw")
    public suspend fun debugParams(`value`: Output<String>) {
        this.debugParams = value
    }

    /**
     * @param value User readable description of the application.
     */
    @JvmName("afbwhdpqflobymgq")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Describes the diagnostics definition and usage for an application resource.
     */
    @JvmName("scriwujoouhidxal")
    public suspend fun diagnostics(`value`: Output<DiagnosticsDescriptionArgs>) {
        this.diagnostics = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("qxkikdiqauyrlait")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Azure resource group name
     */
    @JvmName("qheiointjpgpolrb")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Describes the services in the application. This property is used to create or modify services of the application. On get only the name of the service is returned. The service description can be obtained by querying for the service resource.
     */
    @JvmName("iomfoyrqtakdernx")
    public suspend fun services(`value`: Output<List<ServiceResourceDescriptionArgs>>) {
        this.services = value
    }

    @JvmName("hmcaiksrxxxeppga")
    public suspend fun services(vararg values: Output<ServiceResourceDescriptionArgs>) {
        this.services = Output.all(values.asList())
    }

    /**
     * @param values Describes the services in the application. This property is used to create or modify services of the application. On get only the name of the service is returned. The service description can be obtained by querying for the service resource.
     */
    @JvmName("xkgwbypcfqcfnlkq")
    public suspend fun services(values: List<Output<ServiceResourceDescriptionArgs>>) {
        this.services = Output.all(values)
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ehiugfasyhsmbhuc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The identity of the application.
     */
    @JvmName("dtrhxvpmsllovkit")
    public suspend fun applicationResourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationResourceName = mapped
    }

    /**
     * @param value Internal - used by Visual Studio to setup the debugging session on the local development environment.
     */
    @JvmName("mbxrjidyxdgjnaui")
    public suspend fun debugParams(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.debugParams = mapped
    }

    /**
     * @param value User readable description of the application.
     */
    @JvmName("dwworueetwiyvkpv")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Describes the diagnostics definition and usage for an application resource.
     */
    @JvmName("mnlfluflqtiylace")
    public suspend fun diagnostics(`value`: DiagnosticsDescriptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diagnostics = mapped
    }

    /**
     * @param argument Describes the diagnostics definition and usage for an application resource.
     */
    @JvmName("hxcrdeejswcmfmqp")
    public suspend fun diagnostics(argument: suspend DiagnosticsDescriptionArgsBuilder.() -> Unit) {
        val toBeMapped = DiagnosticsDescriptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.diagnostics = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("rcyoiquijkumiyrm")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Azure resource group name
     */
    @JvmName("qsaymjtehtelhlkl")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Describes the services in the application. This property is used to create or modify services of the application. On get only the name of the service is returned. The service description can be obtained by querying for the service resource.
     */
    @JvmName("xkgvsmajoebndren")
    public suspend fun services(`value`: List<ServiceResourceDescriptionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.services = mapped
    }

    /**
     * @param argument Describes the services in the application. This property is used to create or modify services of the application. On get only the name of the service is returned. The service description can be obtained by querying for the service resource.
     */
    @JvmName("wfjkjrytyliqjqyn")
    public suspend
    fun services(argument: List<suspend ServiceResourceDescriptionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ServiceResourceDescriptionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.services = mapped
    }

    /**
     * @param argument Describes the services in the application. This property is used to create or modify services of the application. On get only the name of the service is returned. The service description can be obtained by querying for the service resource.
     */
    @JvmName("esvsuwptrdgvxdag")
    public suspend fun services(
        vararg
        argument: suspend ServiceResourceDescriptionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ServiceResourceDescriptionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.services = mapped
    }

    /**
     * @param argument Describes the services in the application. This property is used to create or modify services of the application. On get only the name of the service is returned. The service description can be obtained by querying for the service resource.
     */
    @JvmName("cmgeyfkyvtauybbb")
    public suspend fun services(argument: suspend ServiceResourceDescriptionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ServiceResourceDescriptionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.services = mapped
    }

    /**
     * @param values Describes the services in the application. This property is used to create or modify services of the application. On get only the name of the service is returned. The service description can be obtained by querying for the service resource.
     */
    @JvmName("kmhxjhxkldpugxql")
    public suspend fun services(vararg values: ServiceResourceDescriptionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.services = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ogcjxclwskfunfsi")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("efrrbdevixmvretn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ApplicationArgs = ApplicationArgs(
        applicationResourceName = applicationResourceName,
        debugParams = debugParams,
        description = description,
        diagnostics = diagnostics,
        location = location,
        resourceGroupName = resourceGroupName,
        services = services,
        tags = tags,
    )
}
