@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin

import com.pulumi.azurenative.servicefabricmesh.SecretArgs.builder
import com.pulumi.azurenative.servicefabricmesh.kotlin.inputs.SecretResourcePropertiesArgs
import com.pulumi.azurenative.servicefabricmesh.kotlin.inputs.SecretResourcePropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * This type describes a secret resource.
 * Azure REST API version: 2018-09-01-preview. Prior API version in Azure Native 1.x: 2018-09-01-preview.
 * ## Example Usage
 * ### CreateOrUpdateSecret
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var secret = new AzureNative.ServiceFabricMesh.Secret("secret", new()
 *     {
 *         Location = "EastUS",
 *         Properties = null,
 *         ResourceGroupName = "sbz_demo",
 *         SecretResourceName = "dbConnectionString",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicefabricmesh/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicefabricmesh.NewSecret(ctx, "secret", &servicefabricmesh.SecretArgs{
 * 			Location:           pulumi.String("EastUS"),
 * 			Properties:         nil,
 * 			ResourceGroupName:  pulumi.String("sbz_demo"),
 * 			SecretResourceName: pulumi.String("dbConnectionString"),
 * 			Tags:               nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicefabricmesh.Secret;
 * import com.pulumi.azurenative.servicefabricmesh.SecretArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var secret = new Secret("secret", SecretArgs.builder()
 *             .location("EastUS")
 *             .properties()
 *             .resourceGroupName("sbz_demo")
 *             .secretResourceName("dbConnectionString")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:servicefabricmesh:Secret dbConnectionString /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceFabricMesh/secrets/{secretResourceName}
 * ```
 * @property location The geo-location where the resource lives
 * @property properties Describes the properties of a secret resource.
 * @property resourceGroupName Azure resource group name
 * @property secretResourceName The name of the secret resource.
 * @property tags Resource tags.
 */
public data class SecretArgs(
    public val location: Output<String>? = null,
    public val properties: Output<SecretResourcePropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val secretResourceName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabricmesh.SecretArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabricmesh.SecretArgs =
        com.pulumi.azurenative.servicefabricmesh.SecretArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .secretResourceName(secretResourceName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SecretArgs].
 */
@PulumiTagMarker
public class SecretArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var properties: Output<SecretResourcePropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var secretResourceName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("mvcfodqmfpjqxtcl")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Describes the properties of a secret resource.
     */
    @JvmName("jpbymdxvtuthktqp")
    public suspend fun properties(`value`: Output<SecretResourcePropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value Azure resource group name
     */
    @JvmName("oycibmlkyerlmnax")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the secret resource.
     */
    @JvmName("rlaatlsytevqaava")
    public suspend fun secretResourceName(`value`: Output<String>) {
        this.secretResourceName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ihyoaiptvxfuvtns")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("jggmjmrflnotlpcp")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Describes the properties of a secret resource.
     */
    @JvmName("enwbyecqulcbmsua")
    public suspend fun properties(`value`: SecretResourcePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Describes the properties of a secret resource.
     */
    @JvmName("gkjwutnudqcqtthw")
    public suspend fun properties(argument: suspend SecretResourcePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = SecretResourcePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value Azure resource group name
     */
    @JvmName("sfwkvvovcsplgfdl")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the secret resource.
     */
    @JvmName("vhnbqfgacigdgbyl")
    public suspend fun secretResourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretResourceName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("iyqtqtekkiugkiyw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("ldiuvfvpxbohegnt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SecretArgs = SecretArgs(
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        secretResourceName = secretResourceName,
        tags = tags,
    )
}
