@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin

import com.pulumi.azurenative.servicefabricmesh.VolumeArgs.builder
import com.pulumi.azurenative.servicefabricmesh.kotlin.enums.VolumeProvider
import com.pulumi.azurenative.servicefabricmesh.kotlin.inputs.VolumeProviderParametersAzureFileArgs
import com.pulumi.azurenative.servicefabricmesh.kotlin.inputs.VolumeProviderParametersAzureFileArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * This type describes a volume resource.
 * Azure REST API version: 2018-09-01-preview. Prior API version in Azure Native 1.x: 2018-09-01-preview.
 * Other available API versions: 2018-07-01-preview.
 * ## Example Usage
 * ### CreateOrUpdateVolume
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var volume = new AzureNative.ServiceFabricMesh.Volume("volume", new()
 *     {
 *         AzureFileParameters = new AzureNative.ServiceFabricMesh.Inputs.VolumeProviderParametersAzureFileArgs
 *         {
 *             AccountKey = "provide-account-key-here",
 *             AccountName = "sbzdemoaccount",
 *             ShareName = "sharel",
 *         },
 *         Description = "Service Fabric Mesh sample volume.",
 *         Location = "EastUS",
 *         Provider = "SFAzureFile",
 *         ResourceGroupName = "sbz_demo",
 *         Tags = null,
 *         VolumeResourceName = "sampleVolume",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicefabricmesh/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicefabricmesh.NewVolume(ctx, "volume", &servicefabricmesh.VolumeArgs{
 * 			AzureFileParameters: &servicefabricmesh.VolumeProviderParametersAzureFileArgs{
 * 				AccountKey:  pulumi.String("provide-account-key-here"),
 * 				AccountName: pulumi.String("sbzdemoaccount"),
 * 				ShareName:   pulumi.String("sharel"),
 * 			},
 * 			Description:        pulumi.String("Service Fabric Mesh sample volume."),
 * 			Location:           pulumi.String("EastUS"),
 * 			Provider:           pulumi.String("SFAzureFile"),
 * 			ResourceGroupName:  pulumi.String("sbz_demo"),
 * 			Tags:               nil,
 * 			VolumeResourceName: pulumi.String("sampleVolume"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicefabricmesh.Volume;
 * import com.pulumi.azurenative.servicefabricmesh.VolumeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var volume = new Volume("volume", VolumeArgs.builder()
 *             .azureFileParameters(Map.ofEntries(
 *                 Map.entry("accountKey", "provide-account-key-here"),
 *                 Map.entry("accountName", "sbzdemoaccount"),
 *                 Map.entry("shareName", "sharel")
 *             ))
 *             .description("Service Fabric Mesh sample volume.")
 *             .location("EastUS")
 *             .provider("SFAzureFile")
 *             .resourceGroupName("sbz_demo")
 *             .tags()
 *             .volumeResourceName("sampleVolume")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:servicefabricmesh:Volume sampleVolume /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceFabricMesh/volumes/{volumeResourceName}
 * ```
 * @property azureFileParameters This type describes a volume provided by an Azure Files file share.
 * @property description User readable description of the volume.
 * @property location The geo-location where the resource lives
 * @property provider Provider of the volume.
 * @property resourceGroupName Azure resource group name
 * @property tags Resource tags.
 * @property volumeResourceName The identity of the volume.
 */
public data class VolumeArgs(
    public val azureFileParameters: Output<VolumeProviderParametersAzureFileArgs>? = null,
    public val description: Output<String>? = null,
    public val location: Output<String>? = null,
    public val provider: Output<Either<String, VolumeProvider>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val volumeResourceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabricmesh.VolumeArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabricmesh.VolumeArgs =
        com.pulumi.azurenative.servicefabricmesh.VolumeArgs.builder()
            .azureFileParameters(
                azureFileParameters?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .provider(
                provider?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .volumeResourceName(volumeResourceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VolumeArgs].
 */
@PulumiTagMarker
public class VolumeArgsBuilder internal constructor() {
    private var azureFileParameters: Output<VolumeProviderParametersAzureFileArgs>? = null

    private var description: Output<String>? = null

    private var location: Output<String>? = null

    private var provider: Output<Either<String, VolumeProvider>>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var volumeResourceName: Output<String>? = null

    /**
     * @param value This type describes a volume provided by an Azure Files file share.
     */
    @JvmName("niejukinfxhcqean")
    public suspend fun azureFileParameters(`value`: Output<VolumeProviderParametersAzureFileArgs>) {
        this.azureFileParameters = value
    }

    /**
     * @param value User readable description of the volume.
     */
    @JvmName("hnsrawjqutdijnwx")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("wflqtteyxalqfgia")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Provider of the volume.
     */
    @JvmName("vlhgvwgeegpfkdhl")
    public suspend fun provider(`value`: Output<Either<String, VolumeProvider>>) {
        this.provider = value
    }

    /**
     * @param value Azure resource group name
     */
    @JvmName("kaamdxbqgjpmjucu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("laqjibjqkynmelwy")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The identity of the volume.
     */
    @JvmName("cyexwvhygfrvkrbp")
    public suspend fun volumeResourceName(`value`: Output<String>) {
        this.volumeResourceName = value
    }

    /**
     * @param value This type describes a volume provided by an Azure Files file share.
     */
    @JvmName("avynxmffnwmgtxbe")
    public suspend fun azureFileParameters(`value`: VolumeProviderParametersAzureFileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureFileParameters = mapped
    }

    /**
     * @param argument This type describes a volume provided by an Azure Files file share.
     */
    @JvmName("ogwxfomsnhjjjwci")
    public suspend
    fun azureFileParameters(argument: suspend VolumeProviderParametersAzureFileArgsBuilder.() -> Unit) {
        val toBeMapped = VolumeProviderParametersAzureFileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.azureFileParameters = mapped
    }

    /**
     * @param value User readable description of the volume.
     */
    @JvmName("vjvhjbgutnflxhar")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("afrbiambhaowcpyh")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Provider of the volume.
     */
    @JvmName("lybpswlmqgcuynem")
    public suspend fun provider(`value`: Either<String, VolumeProvider>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provider = mapped
    }

    /**
     * @param value Provider of the volume.
     */
    @JvmName("grrylhscjjoiwrgo")
    public fun provider(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VolumeProvider>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provider = mapped
    }

    /**
     * @param value Provider of the volume.
     */
    @JvmName("cospwbxabmwsxmyi")
    public fun provider(`value`: VolumeProvider) {
        val toBeMapped = Either.ofRight<String, VolumeProvider>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provider = mapped
    }

    /**
     * @param value Azure resource group name
     */
    @JvmName("qdkcovusmpqkcnud")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("msthpreugwoukike")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("ataabqxljlvtgyti")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The identity of the volume.
     */
    @JvmName("manmiccrofbaxvbx")
    public suspend fun volumeResourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeResourceName = mapped
    }

    internal fun build(): VolumeArgs = VolumeArgs(
        azureFileParameters = azureFileParameters,
        description = description,
        location = location,
        provider = provider,
        resourceGroupName = resourceGroupName,
        tags = tags,
        volumeResourceName = volumeResourceName,
    )
}
