@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Name of the resource.
 */
public enum class AutoScalingResourceMetricName(
    public val javaValue:
    com.pulumi.azurenative.servicefabricmesh.enums.AutoScalingResourceMetricName,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabricmesh.enums.AutoScalingResourceMetricName> {
    /**
     * Indicates that the resource is CPU cores.
     */
    Cpu(com.pulumi.azurenative.servicefabricmesh.enums.AutoScalingResourceMetricName.Cpu),

    /**
     * Indicates that the resource is memory in GB.
     */
    MemoryInGB(com.pulumi.azurenative.servicefabricmesh.enums.AutoScalingResourceMetricName.MemoryInGB),
    ;

    override fun toJava():
        com.pulumi.azurenative.servicefabricmesh.enums.AutoScalingResourceMetricName = javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicefabricmesh.enums.AutoScalingResourceMetricName):
            AutoScalingResourceMetricName =
            AutoScalingResourceMetricName.values().first { it.javaValue == javaType }
    }
}
