@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.inputs

import com.pulumi.azurenative.servicefabricmesh.inputs.AutoScalingResourceMetricArgs.builder
import com.pulumi.azurenative.servicefabricmesh.kotlin.enums.AutoScalingResourceMetricName
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the resource that is used for triggering auto scaling.
 * @property kind Enumerates the metrics that are used for triggering auto scaling.
 * Expected value is 'Resource'.
 * @property name Name of the resource.
 */
public data class AutoScalingResourceMetricArgs(
    public val kind: Output<String>,
    public val name: Output<Either<String, AutoScalingResourceMetricName>>,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabricmesh.inputs.AutoScalingResourceMetricArgs> {
    override fun toJava():
        com.pulumi.azurenative.servicefabricmesh.inputs.AutoScalingResourceMetricArgs =
        com.pulumi.azurenative.servicefabricmesh.inputs.AutoScalingResourceMetricArgs.builder()
            .kind(kind.applyValue({ args0 -> args0 }))
            .name(
                name.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [AutoScalingResourceMetricArgs].
 */
@PulumiTagMarker
public class AutoScalingResourceMetricArgsBuilder internal constructor() {
    private var kind: Output<String>? = null

    private var name: Output<Either<String, AutoScalingResourceMetricName>>? = null

    /**
     * @param value Enumerates the metrics that are used for triggering auto scaling.
     * Expected value is 'Resource'.
     */
    @JvmName("tuwalsguawddtrom")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Name of the resource.
     */
    @JvmName("oiptamikhawldqwg")
    public suspend fun name(`value`: Output<Either<String, AutoScalingResourceMetricName>>) {
        this.name = value
    }

    /**
     * @param value Enumerates the metrics that are used for triggering auto scaling.
     * Expected value is 'Resource'.
     */
    @JvmName("wfxssmjntpdiqqco")
    public suspend fun kind(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Name of the resource.
     */
    @JvmName("knlasoxcurnjvwgg")
    public suspend fun name(`value`: Either<String, AutoScalingResourceMetricName>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of the resource.
     */
    @JvmName("idqlaoxvqwbwtcnv")
    public fun name(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AutoScalingResourceMetricName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of the resource.
     */
    @JvmName("arjoqbhhmxbccgjs")
    public fun name(`value`: AutoScalingResourceMetricName) {
        val toBeMapped = Either.ofRight<String, AutoScalingResourceMetricName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): AutoScalingResourceMetricArgs = AutoScalingResourceMetricArgs(
        kind = kind ?: throw PulumiNullFieldException("kind"),
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
