@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.inputs

import com.pulumi.azurenative.servicefabricmesh.inputs.AverageLoadScalingTriggerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Describes the average load trigger used for auto scaling.
 * @property kind Enumerates the triggers for auto scaling.
 * Expected value is 'AverageLoad'.
 * @property lowerLoadThreshold Lower load threshold (if average load is below this threshold, service will scale down).
 * @property metric Description of the metric that is used for scaling.
 * @property scaleIntervalInSeconds Scale interval that indicates how often will this trigger be checked.
 * @property upperLoadThreshold Upper load threshold (if average load is above this threshold, service will scale up).
 */
public data class AverageLoadScalingTriggerArgs(
    public val kind: Output<String>,
    public val lowerLoadThreshold: Output<Double>,
    public val metric: Output<AutoScalingResourceMetricArgs>,
    public val scaleIntervalInSeconds: Output<Int>,
    public val upperLoadThreshold: Output<Double>,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabricmesh.inputs.AverageLoadScalingTriggerArgs> {
    override fun toJava():
        com.pulumi.azurenative.servicefabricmesh.inputs.AverageLoadScalingTriggerArgs =
        com.pulumi.azurenative.servicefabricmesh.inputs.AverageLoadScalingTriggerArgs.builder()
            .kind(kind.applyValue({ args0 -> args0 }))
            .lowerLoadThreshold(lowerLoadThreshold.applyValue({ args0 -> args0 }))
            .metric(metric.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .scaleIntervalInSeconds(scaleIntervalInSeconds.applyValue({ args0 -> args0 }))
            .upperLoadThreshold(upperLoadThreshold.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AverageLoadScalingTriggerArgs].
 */
@PulumiTagMarker
public class AverageLoadScalingTriggerArgsBuilder internal constructor() {
    private var kind: Output<String>? = null

    private var lowerLoadThreshold: Output<Double>? = null

    private var metric: Output<AutoScalingResourceMetricArgs>? = null

    private var scaleIntervalInSeconds: Output<Int>? = null

    private var upperLoadThreshold: Output<Double>? = null

    /**
     * @param value Enumerates the triggers for auto scaling.
     * Expected value is 'AverageLoad'.
     */
    @JvmName("dlqfygsktoifnpjj")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Lower load threshold (if average load is below this threshold, service will scale down).
     */
    @JvmName("vyjgiqtmelmsjrml")
    public suspend fun lowerLoadThreshold(`value`: Output<Double>) {
        this.lowerLoadThreshold = value
    }

    /**
     * @param value Description of the metric that is used for scaling.
     */
    @JvmName("dvgbcbgcibcdjnjg")
    public suspend fun metric(`value`: Output<AutoScalingResourceMetricArgs>) {
        this.metric = value
    }

    /**
     * @param value Scale interval that indicates how often will this trigger be checked.
     */
    @JvmName("repyqnoyngoatify")
    public suspend fun scaleIntervalInSeconds(`value`: Output<Int>) {
        this.scaleIntervalInSeconds = value
    }

    /**
     * @param value Upper load threshold (if average load is above this threshold, service will scale up).
     */
    @JvmName("nglreeqltjrfjxqx")
    public suspend fun upperLoadThreshold(`value`: Output<Double>) {
        this.upperLoadThreshold = value
    }

    /**
     * @param value Enumerates the triggers for auto scaling.
     * Expected value is 'AverageLoad'.
     */
    @JvmName("sbwkjeklmskirvnj")
    public suspend fun kind(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Lower load threshold (if average load is below this threshold, service will scale down).
     */
    @JvmName("nmlcxqahjjmpufdn")
    public suspend fun lowerLoadThreshold(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lowerLoadThreshold = mapped
    }

    /**
     * @param value Description of the metric that is used for scaling.
     */
    @JvmName("yxrixjvbxyvfsrsa")
    public suspend fun metric(`value`: AutoScalingResourceMetricArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metric = mapped
    }

    /**
     * @param argument Description of the metric that is used for scaling.
     */
    @JvmName("neqedgsfydsryuxs")
    public suspend fun metric(argument: suspend AutoScalingResourceMetricArgsBuilder.() -> Unit) {
        val toBeMapped = AutoScalingResourceMetricArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.metric = mapped
    }

    /**
     * @param value Scale interval that indicates how often will this trigger be checked.
     */
    @JvmName("bdbyioiolauxsusv")
    public suspend fun scaleIntervalInSeconds(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scaleIntervalInSeconds = mapped
    }

    /**
     * @param value Upper load threshold (if average load is above this threshold, service will scale up).
     */
    @JvmName("omcxbrrmetjrugxv")
    public suspend fun upperLoadThreshold(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.upperLoadThreshold = mapped
    }

    internal fun build(): AverageLoadScalingTriggerArgs = AverageLoadScalingTriggerArgs(
        kind = kind ?: throw PulumiNullFieldException("kind"),
        lowerLoadThreshold = lowerLoadThreshold ?: throw PulumiNullFieldException("lowerLoadThreshold"),
        metric = metric ?: throw PulumiNullFieldException("metric"),
        scaleIntervalInSeconds = scaleIntervalInSeconds ?: throw
            PulumiNullFieldException("scaleIntervalInSeconds"),
        upperLoadThreshold = upperLoadThreshold ?: throw PulumiNullFieldException("upperLoadThreshold"),
    )
}
