@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.inputs

import com.pulumi.azurenative.servicefabricmesh.inputs.ContainerCodePackagePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes a container and its runtime properties.
 * @property commands Command array to execute within the container in exec form.
 * @property diagnostics Reference to sinks in DiagnosticsDescription.
 * @property endpoints The endpoints exposed by this container.
 * @property entrypoint Override for the default entry point in the container.
 * @property environmentVariables The environment variables to set in this container
 * @property image The Container image to use.
 * @property imageRegistryCredential Image registry credential.
 * @property labels The labels to set in this container.
 * @property name The name of the code package.
 * @property reliableCollectionsRefs A list of ReliableCollection resources used by this particular code package. Please refer to ReliableCollectionsRef for more details.
 * @property resources The resources required by this container.
 * @property settings The settings to set in this container. The setting file path can be fetched from environment variable "Fabric_SettingPath". The path for Windows container is "C:\\secrets". The path for Linux container is "/var/secrets".
 * @property volumeRefs Volumes to be attached to the container. The lifetime of these volumes is independent of the application's lifetime.
 * @property volumes Volumes to be attached to the container. The lifetime of these volumes is scoped to the application's lifetime.
 */
public data class ContainerCodePackagePropertiesArgs(
    public val commands: Output<List<String>>? = null,
    public val diagnostics: Output<DiagnosticsRefArgs>? = null,
    public val endpoints: Output<List<EndpointPropertiesArgs>>? = null,
    public val entrypoint: Output<String>? = null,
    public val environmentVariables: Output<List<EnvironmentVariableArgs>>? = null,
    public val image: Output<String>,
    public val imageRegistryCredential: Output<ImageRegistryCredentialArgs>? = null,
    public val labels: Output<List<ContainerLabelArgs>>? = null,
    public val name: Output<String>,
    public val reliableCollectionsRefs: Output<List<ReliableCollectionsRefArgs>>? = null,
    public val resources: Output<ResourceRequirementsArgs>,
    public val settings: Output<List<SettingArgs>>? = null,
    public val volumeRefs: Output<List<VolumeReferenceArgs>>? = null,
    public val volumes: Output<List<ApplicationScopedVolumeArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.servicefabricmesh.inputs.ContainerCodePackagePropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.servicefabricmesh.inputs.ContainerCodePackagePropertiesArgs =
        com.pulumi.azurenative.servicefabricmesh.inputs.ContainerCodePackagePropertiesArgs.builder()
            .commands(commands?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .diagnostics(diagnostics?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .endpoints(
                endpoints?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .entrypoint(entrypoint?.applyValue({ args0 -> args0 }))
            .environmentVariables(
                environmentVariables?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .image(image.applyValue({ args0 -> args0 }))
            .imageRegistryCredential(
                imageRegistryCredential?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .labels(labels?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .reliableCollectionsRefs(
                reliableCollectionsRefs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resources(resources.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .settings(
                settings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .volumeRefs(
                volumeRefs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .volumes(
                volumes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ContainerCodePackagePropertiesArgs].
 */
@PulumiTagMarker
public class ContainerCodePackagePropertiesArgsBuilder internal constructor() {
    private var commands: Output<List<String>>? = null

    private var diagnostics: Output<DiagnosticsRefArgs>? = null

    private var endpoints: Output<List<EndpointPropertiesArgs>>? = null

    private var entrypoint: Output<String>? = null

    private var environmentVariables: Output<List<EnvironmentVariableArgs>>? = null

    private var image: Output<String>? = null

    private var imageRegistryCredential: Output<ImageRegistryCredentialArgs>? = null

    private var labels: Output<List<ContainerLabelArgs>>? = null

    private var name: Output<String>? = null

    private var reliableCollectionsRefs: Output<List<ReliableCollectionsRefArgs>>? = null

    private var resources: Output<ResourceRequirementsArgs>? = null

    private var settings: Output<List<SettingArgs>>? = null

    private var volumeRefs: Output<List<VolumeReferenceArgs>>? = null

    private var volumes: Output<List<ApplicationScopedVolumeArgs>>? = null

    /**
     * @param value Command array to execute within the container in exec form.
     */
    @JvmName("gevigmyutxvjgukw")
    public suspend fun commands(`value`: Output<List<String>>) {
        this.commands = value
    }

    @JvmName("wvobircyjaxmqoha")
    public suspend fun commands(vararg values: Output<String>) {
        this.commands = Output.all(values.asList())
    }

    /**
     * @param values Command array to execute within the container in exec form.
     */
    @JvmName("rxdoapcbknkisjby")
    public suspend fun commands(values: List<Output<String>>) {
        this.commands = Output.all(values)
    }

    /**
     * @param value Reference to sinks in DiagnosticsDescription.
     */
    @JvmName("sbrfkaugpwkcmwhi")
    public suspend fun diagnostics(`value`: Output<DiagnosticsRefArgs>) {
        this.diagnostics = value
    }

    /**
     * @param value The endpoints exposed by this container.
     */
    @JvmName("sgkbwdvsoyuwiiiv")
    public suspend fun endpoints(`value`: Output<List<EndpointPropertiesArgs>>) {
        this.endpoints = value
    }

    @JvmName("qbqwsvemogxnwmtk")
    public suspend fun endpoints(vararg values: Output<EndpointPropertiesArgs>) {
        this.endpoints = Output.all(values.asList())
    }

    /**
     * @param values The endpoints exposed by this container.
     */
    @JvmName("jxichsrlowoybywn")
    public suspend fun endpoints(values: List<Output<EndpointPropertiesArgs>>) {
        this.endpoints = Output.all(values)
    }

    /**
     * @param value Override for the default entry point in the container.
     */
    @JvmName("mntilxgupaoybwxa")
    public suspend fun entrypoint(`value`: Output<String>) {
        this.entrypoint = value
    }

    /**
     * @param value The environment variables to set in this container
     */
    @JvmName("lpmwlqcggsxvpdwo")
    public suspend fun environmentVariables(`value`: Output<List<EnvironmentVariableArgs>>) {
        this.environmentVariables = value
    }

    @JvmName("itorpbrqlixhfvww")
    public suspend fun environmentVariables(vararg values: Output<EnvironmentVariableArgs>) {
        this.environmentVariables = Output.all(values.asList())
    }

    /**
     * @param values The environment variables to set in this container
     */
    @JvmName("osxultqdwlgfeksp")
    public suspend fun environmentVariables(values: List<Output<EnvironmentVariableArgs>>) {
        this.environmentVariables = Output.all(values)
    }

    /**
     * @param value The Container image to use.
     */
    @JvmName("huedjybdnwrddbrq")
    public suspend fun image(`value`: Output<String>) {
        this.image = value
    }

    /**
     * @param value Image registry credential.
     */
    @JvmName("tofnmbonekhspwgh")
    public suspend fun imageRegistryCredential(`value`: Output<ImageRegistryCredentialArgs>) {
        this.imageRegistryCredential = value
    }

    /**
     * @param value The labels to set in this container.
     */
    @JvmName("opxfrjsnmeyivwvl")
    public suspend fun labels(`value`: Output<List<ContainerLabelArgs>>) {
        this.labels = value
    }

    @JvmName("iixgsvrscehmiyir")
    public suspend fun labels(vararg values: Output<ContainerLabelArgs>) {
        this.labels = Output.all(values.asList())
    }

    /**
     * @param values The labels to set in this container.
     */
    @JvmName("wnbmfxqbtuswtgos")
    public suspend fun labels(values: List<Output<ContainerLabelArgs>>) {
        this.labels = Output.all(values)
    }

    /**
     * @param value The name of the code package.
     */
    @JvmName("kduocpimvahmmbnp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A list of ReliableCollection resources used by this particular code package. Please refer to ReliableCollectionsRef for more details.
     */
    @JvmName("tpsqxrrvhqjgcjva")
    public suspend fun reliableCollectionsRefs(`value`: Output<List<ReliableCollectionsRefArgs>>) {
        this.reliableCollectionsRefs = value
    }

    @JvmName("wmeppqjipwcctolj")
    public suspend fun reliableCollectionsRefs(vararg values: Output<ReliableCollectionsRefArgs>) {
        this.reliableCollectionsRefs = Output.all(values.asList())
    }

    /**
     * @param values A list of ReliableCollection resources used by this particular code package. Please refer to ReliableCollectionsRef for more details.
     */
    @JvmName("ifnjyherumvtouit")
    public suspend fun reliableCollectionsRefs(values: List<Output<ReliableCollectionsRefArgs>>) {
        this.reliableCollectionsRefs = Output.all(values)
    }

    /**
     * @param value The resources required by this container.
     */
    @JvmName("bwwlkhunmrbfkslp")
    public suspend fun resources(`value`: Output<ResourceRequirementsArgs>) {
        this.resources = value
    }

    /**
     * @param value The settings to set in this container. The setting file path can be fetched from environment variable "Fabric_SettingPath". The path for Windows container is "C:\\secrets". The path for Linux container is "/var/secrets".
     */
    @JvmName("ixbmnsbpclefxthx")
    public suspend fun settings(`value`: Output<List<SettingArgs>>) {
        this.settings = value
    }

    @JvmName("kfwnxcpwikbmwgtr")
    public suspend fun settings(vararg values: Output<SettingArgs>) {
        this.settings = Output.all(values.asList())
    }

    /**
     * @param values The settings to set in this container. The setting file path can be fetched from environment variable "Fabric_SettingPath". The path for Windows container is "C:\\secrets". The path for Linux container is "/var/secrets".
     */
    @JvmName("auqgpatsgufqwqgw")
    public suspend fun settings(values: List<Output<SettingArgs>>) {
        this.settings = Output.all(values)
    }

    /**
     * @param value Volumes to be attached to the container. The lifetime of these volumes is independent of the application's lifetime.
     */
    @JvmName("kemrxvqombbympku")
    public suspend fun volumeRefs(`value`: Output<List<VolumeReferenceArgs>>) {
        this.volumeRefs = value
    }

    @JvmName("aaiofrepopqjucqi")
    public suspend fun volumeRefs(vararg values: Output<VolumeReferenceArgs>) {
        this.volumeRefs = Output.all(values.asList())
    }

    /**
     * @param values Volumes to be attached to the container. The lifetime of these volumes is independent of the application's lifetime.
     */
    @JvmName("dwlrktevueqwyuwa")
    public suspend fun volumeRefs(values: List<Output<VolumeReferenceArgs>>) {
        this.volumeRefs = Output.all(values)
    }

    /**
     * @param value Volumes to be attached to the container. The lifetime of these volumes is scoped to the application's lifetime.
     */
    @JvmName("qoyohtktkllgtqev")
    public suspend fun volumes(`value`: Output<List<ApplicationScopedVolumeArgs>>) {
        this.volumes = value
    }

    @JvmName("ydemegxfkexnemme")
    public suspend fun volumes(vararg values: Output<ApplicationScopedVolumeArgs>) {
        this.volumes = Output.all(values.asList())
    }

    /**
     * @param values Volumes to be attached to the container. The lifetime of these volumes is scoped to the application's lifetime.
     */
    @JvmName("qskuerfqbuoroymq")
    public suspend fun volumes(values: List<Output<ApplicationScopedVolumeArgs>>) {
        this.volumes = Output.all(values)
    }

    /**
     * @param value Command array to execute within the container in exec form.
     */
    @JvmName("glnunswhmgbnqeqh")
    public suspend fun commands(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commands = mapped
    }

    /**
     * @param values Command array to execute within the container in exec form.
     */
    @JvmName("mdrvlajtbpaifswj")
    public suspend fun commands(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.commands = mapped
    }

    /**
     * @param value Reference to sinks in DiagnosticsDescription.
     */
    @JvmName("bllfpmvkcryewtnt")
    public suspend fun diagnostics(`value`: DiagnosticsRefArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diagnostics = mapped
    }

    /**
     * @param argument Reference to sinks in DiagnosticsDescription.
     */
    @JvmName("ecfgopikasnaturc")
    public suspend fun diagnostics(argument: suspend DiagnosticsRefArgsBuilder.() -> Unit) {
        val toBeMapped = DiagnosticsRefArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.diagnostics = mapped
    }

    /**
     * @param value The endpoints exposed by this container.
     */
    @JvmName("gpdnliqnrxqosqia")
    public suspend fun endpoints(`value`: List<EndpointPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpoints = mapped
    }

    /**
     * @param argument The endpoints exposed by this container.
     */
    @JvmName("obedsjwptqxxengc")
    public suspend fun endpoints(argument: List<suspend EndpointPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EndpointPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.endpoints = mapped
    }

    /**
     * @param argument The endpoints exposed by this container.
     */
    @JvmName("afxdnyjifcfatwqa")
    public suspend fun endpoints(vararg argument: suspend EndpointPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EndpointPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.endpoints = mapped
    }

    /**
     * @param argument The endpoints exposed by this container.
     */
    @JvmName("vscfoivutyxgxkvf")
    public suspend fun endpoints(argument: suspend EndpointPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(EndpointPropertiesArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.endpoints = mapped
    }

    /**
     * @param values The endpoints exposed by this container.
     */
    @JvmName("elsroecmvhdgmbqp")
    public suspend fun endpoints(vararg values: EndpointPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpoints = mapped
    }

    /**
     * @param value Override for the default entry point in the container.
     */
    @JvmName("gorasbfenmpqdkla")
    public suspend fun entrypoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.entrypoint = mapped
    }

    /**
     * @param value The environment variables to set in this container
     */
    @JvmName("bskpdijbtanpxgml")
    public suspend fun environmentVariables(`value`: List<EnvironmentVariableArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentVariables = mapped
    }

    /**
     * @param argument The environment variables to set in this container
     */
    @JvmName("whredutboeaadddo")
    public suspend
    fun environmentVariables(argument: List<suspend EnvironmentVariableArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EnvironmentVariableArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.environmentVariables = mapped
    }

    /**
     * @param argument The environment variables to set in this container
     */
    @JvmName("iqcexrmyhftebkgp")
    public suspend fun environmentVariables(
        vararg
        argument: suspend EnvironmentVariableArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            EnvironmentVariableArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.environmentVariables = mapped
    }

    /**
     * @param argument The environment variables to set in this container
     */
    @JvmName("mdaogxypvxugnjtm")
    public suspend
    fun environmentVariables(argument: suspend EnvironmentVariableArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(EnvironmentVariableArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.environmentVariables = mapped
    }

    /**
     * @param values The environment variables to set in this container
     */
    @JvmName("hpsedwwdrbvqiedd")
    public suspend fun environmentVariables(vararg values: EnvironmentVariableArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environmentVariables = mapped
    }

    /**
     * @param value The Container image to use.
     */
    @JvmName("rfckejmjrftqugqn")
    public suspend fun image(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.image = mapped
    }

    /**
     * @param value Image registry credential.
     */
    @JvmName("wevvbfxxvbialwiu")
    public suspend fun imageRegistryCredential(`value`: ImageRegistryCredentialArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageRegistryCredential = mapped
    }

    /**
     * @param argument Image registry credential.
     */
    @JvmName("wbkkbecrxhwjjcpq")
    public suspend
    fun imageRegistryCredential(argument: suspend ImageRegistryCredentialArgsBuilder.() -> Unit) {
        val toBeMapped = ImageRegistryCredentialArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.imageRegistryCredential = mapped
    }

    /**
     * @param value The labels to set in this container.
     */
    @JvmName("cvyopecfgcxwsdkr")
    public suspend fun labels(`value`: List<ContainerLabelArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param argument The labels to set in this container.
     */
    @JvmName("yakoymjsdrrbekxt")
    public suspend fun labels(argument: List<suspend ContainerLabelArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContainerLabelArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.labels = mapped
    }

    /**
     * @param argument The labels to set in this container.
     */
    @JvmName("dtprolqyoodbgjfa")
    public suspend fun labels(vararg argument: suspend ContainerLabelArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ContainerLabelArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.labels = mapped
    }

    /**
     * @param argument The labels to set in this container.
     */
    @JvmName("vdbodutpeucnvmmd")
    public suspend fun labels(argument: suspend ContainerLabelArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ContainerLabelArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.labels = mapped
    }

    /**
     * @param values The labels to set in this container.
     */
    @JvmName("mhvpiovacnyvuqfn")
    public suspend fun labels(vararg values: ContainerLabelArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param value The name of the code package.
     */
    @JvmName("vcuaydeqvmxlueds")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A list of ReliableCollection resources used by this particular code package. Please refer to ReliableCollectionsRef for more details.
     */
    @JvmName("yquayvthcdwtkcsh")
    public suspend fun reliableCollectionsRefs(`value`: List<ReliableCollectionsRefArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reliableCollectionsRefs = mapped
    }

    /**
     * @param argument A list of ReliableCollection resources used by this particular code package. Please refer to ReliableCollectionsRef for more details.
     */
    @JvmName("dcobfrsrylsxvvnr")
    public suspend
    fun reliableCollectionsRefs(argument: List<suspend ReliableCollectionsRefArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ReliableCollectionsRefArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.reliableCollectionsRefs = mapped
    }

    /**
     * @param argument A list of ReliableCollection resources used by this particular code package. Please refer to ReliableCollectionsRef for more details.
     */
    @JvmName("xpsqiqxynecfutfv")
    public suspend fun reliableCollectionsRefs(
        vararg
        argument: suspend ReliableCollectionsRefArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ReliableCollectionsRefArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.reliableCollectionsRefs = mapped
    }

    /**
     * @param argument A list of ReliableCollection resources used by this particular code package. Please refer to ReliableCollectionsRef for more details.
     */
    @JvmName("gljlxdoxlxifowks")
    public suspend
    fun reliableCollectionsRefs(argument: suspend ReliableCollectionsRefArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ReliableCollectionsRefArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.reliableCollectionsRefs = mapped
    }

    /**
     * @param values A list of ReliableCollection resources used by this particular code package. Please refer to ReliableCollectionsRef for more details.
     */
    @JvmName("kdviiukcrhljqakk")
    public suspend fun reliableCollectionsRefs(vararg values: ReliableCollectionsRefArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.reliableCollectionsRefs = mapped
    }

    /**
     * @param value The resources required by this container.
     */
    @JvmName("sbiqbarjqvawqfeo")
    public suspend fun resources(`value`: ResourceRequirementsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resources = mapped
    }

    /**
     * @param argument The resources required by this container.
     */
    @JvmName("twgkxfgqriitihnk")
    public suspend fun resources(argument: suspend ResourceRequirementsArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceRequirementsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.resources = mapped
    }

    /**
     * @param value The settings to set in this container. The setting file path can be fetched from environment variable "Fabric_SettingPath". The path for Windows container is "C:\\secrets". The path for Linux container is "/var/secrets".
     */
    @JvmName("ntfvjewavefietcx")
    public suspend fun settings(`value`: List<SettingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.settings = mapped
    }

    /**
     * @param argument The settings to set in this container. The setting file path can be fetched from environment variable "Fabric_SettingPath". The path for Windows container is "C:\\secrets". The path for Linux container is "/var/secrets".
     */
    @JvmName("ookrsniqjigdmoxk")
    public suspend fun settings(argument: List<suspend SettingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SettingArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.settings = mapped
    }

    /**
     * @param argument The settings to set in this container. The setting file path can be fetched from environment variable "Fabric_SettingPath". The path for Windows container is "C:\\secrets". The path for Linux container is "/var/secrets".
     */
    @JvmName("dtfikydkexuspbho")
    public suspend fun settings(vararg argument: suspend SettingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SettingArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.settings = mapped
    }

    /**
     * @param argument The settings to set in this container. The setting file path can be fetched from environment variable "Fabric_SettingPath". The path for Windows container is "C:\\secrets". The path for Linux container is "/var/secrets".
     */
    @JvmName("qmorbtoyxfjsqwmq")
    public suspend fun settings(argument: suspend SettingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SettingArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.settings = mapped
    }

    /**
     * @param values The settings to set in this container. The setting file path can be fetched from environment variable "Fabric_SettingPath". The path for Windows container is "C:\\secrets". The path for Linux container is "/var/secrets".
     */
    @JvmName("rwfmdoojmnhjeymd")
    public suspend fun settings(vararg values: SettingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.settings = mapped
    }

    /**
     * @param value Volumes to be attached to the container. The lifetime of these volumes is independent of the application's lifetime.
     */
    @JvmName("uskbxfwtupwamdxm")
    public suspend fun volumeRefs(`value`: List<VolumeReferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeRefs = mapped
    }

    /**
     * @param argument Volumes to be attached to the container. The lifetime of these volumes is independent of the application's lifetime.
     */
    @JvmName("xxqmyxoynunpxpan")
    public suspend fun volumeRefs(argument: List<suspend VolumeReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VolumeReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.volumeRefs = mapped
    }

    /**
     * @param argument Volumes to be attached to the container. The lifetime of these volumes is independent of the application's lifetime.
     */
    @JvmName("yqpjswngahurssqc")
    public suspend fun volumeRefs(vararg argument: suspend VolumeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            VolumeReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.volumeRefs = mapped
    }

    /**
     * @param argument Volumes to be attached to the container. The lifetime of these volumes is independent of the application's lifetime.
     */
    @JvmName("vmbprogbptdcdaxr")
    public suspend fun volumeRefs(argument: suspend VolumeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VolumeReferenceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.volumeRefs = mapped
    }

    /**
     * @param values Volumes to be attached to the container. The lifetime of these volumes is independent of the application's lifetime.
     */
    @JvmName("mbsegpwgjbbviqyt")
    public suspend fun volumeRefs(vararg values: VolumeReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.volumeRefs = mapped
    }

    /**
     * @param value Volumes to be attached to the container. The lifetime of these volumes is scoped to the application's lifetime.
     */
    @JvmName("hemltplifwclkrpl")
    public suspend fun volumes(`value`: List<ApplicationScopedVolumeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumes = mapped
    }

    /**
     * @param argument Volumes to be attached to the container. The lifetime of these volumes is scoped to the application's lifetime.
     */
    @JvmName("ckpccgpcetvtufua")
    public suspend
    fun volumes(argument: List<suspend ApplicationScopedVolumeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationScopedVolumeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.volumes = mapped
    }

    /**
     * @param argument Volumes to be attached to the container. The lifetime of these volumes is scoped to the application's lifetime.
     */
    @JvmName("xyybnfdsjnnfnhsi")
    public suspend fun volumes(
        vararg
        argument: suspend ApplicationScopedVolumeArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ApplicationScopedVolumeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.volumes = mapped
    }

    /**
     * @param argument Volumes to be attached to the container. The lifetime of these volumes is scoped to the application's lifetime.
     */
    @JvmName("byqdnjymffrxqima")
    public suspend fun volumes(argument: suspend ApplicationScopedVolumeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationScopedVolumeArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.volumes = mapped
    }

    /**
     * @param values Volumes to be attached to the container. The lifetime of these volumes is scoped to the application's lifetime.
     */
    @JvmName("mkiklbqnkasaaxga")
    public suspend fun volumes(vararg values: ApplicationScopedVolumeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.volumes = mapped
    }

    internal fun build(): ContainerCodePackagePropertiesArgs = ContainerCodePackagePropertiesArgs(
        commands = commands,
        diagnostics = diagnostics,
        endpoints = endpoints,
        entrypoint = entrypoint,
        environmentVariables = environmentVariables,
        image = image ?: throw PulumiNullFieldException("image"),
        imageRegistryCredential = imageRegistryCredential,
        labels = labels,
        name = name ?: throw PulumiNullFieldException("name"),
        reliableCollectionsRefs = reliableCollectionsRefs,
        resources = resources ?: throw PulumiNullFieldException("resources"),
        settings = settings,
        volumeRefs = volumeRefs,
        volumes = volumes,
    )
}
