@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.inputs

import com.pulumi.azurenative.servicefabricmesh.inputs.EndpointRefArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes a reference to a service endpoint.
 * @property name Name of the endpoint.
 */
public data class EndpointRefArgs(
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabricmesh.inputs.EndpointRefArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabricmesh.inputs.EndpointRefArgs =
        com.pulumi.azurenative.servicefabricmesh.inputs.EndpointRefArgs.builder()
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointRefArgs].
 */
@PulumiTagMarker
public class EndpointRefArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    /**
     * @param value Name of the endpoint.
     */
    @JvmName("fusrbjrwovebhays")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of the endpoint.
     */
    @JvmName("ypfuxrfouydhxuuf")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): EndpointRefArgs = EndpointRefArgs(
        name = name,
    )
}
