@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.inputs

import com.pulumi.azurenative.servicefabricmesh.inputs.GetApplicationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property applicationResourceName The identity of the application.
 * @property resourceGroupName Azure resource group name
 */
public data class GetApplicationPlainArgs(
    public val applicationResourceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabricmesh.inputs.GetApplicationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabricmesh.inputs.GetApplicationPlainArgs =
        com.pulumi.azurenative.servicefabricmesh.inputs.GetApplicationPlainArgs.builder()
            .applicationResourceName(applicationResourceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetApplicationPlainArgs].
 */
@PulumiTagMarker
public class GetApplicationPlainArgsBuilder internal constructor() {
    private var applicationResourceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The identity of the application.
     */
    @JvmName("avavptabdfqesnlv")
    public suspend fun applicationResourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.applicationResourceName = mapped
    }

    /**
     * @param value Azure resource group name
     */
    @JvmName("hidccfuvfbooicnt")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetApplicationPlainArgs = GetApplicationPlainArgs(
        applicationResourceName = applicationResourceName ?: throw
            PulumiNullFieldException("applicationResourceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
