@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.inputs

import com.pulumi.azurenative.servicefabricmesh.inputs.NetworkResourcePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes properties of a network resource.
 * @property description User readable description of the network.
 * @property kind The type of a Service Fabric container network.
 * Expected value is 'NetworkResourceProperties'.
 */
public data class NetworkResourcePropertiesArgs(
    public val description: Output<String>? = null,
    public val kind: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabricmesh.inputs.NetworkResourcePropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.servicefabricmesh.inputs.NetworkResourcePropertiesArgs =
        com.pulumi.azurenative.servicefabricmesh.inputs.NetworkResourcePropertiesArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .kind(kind.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkResourcePropertiesArgs].
 */
@PulumiTagMarker
public class NetworkResourcePropertiesArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var kind: Output<String>? = null

    /**
     * @param value User readable description of the network.
     */
    @JvmName("worbgmdtvddlbyyo")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The type of a Service Fabric container network.
     * Expected value is 'NetworkResourceProperties'.
     */
    @JvmName("xyvwbqkaunyajqtp")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value User readable description of the network.
     */
    @JvmName("ekdmnhlblldppyyh")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The type of a Service Fabric container network.
     * Expected value is 'NetworkResourceProperties'.
     */
    @JvmName("jygjieavayyvtomv")
    public suspend fun kind(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    internal fun build(): NetworkResourcePropertiesArgs = NetworkResourcePropertiesArgs(
        description = description,
        kind = kind ?: throw PulumiNullFieldException("kind"),
    )
}
