@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.inputs

import com.pulumi.azurenative.servicefabricmesh.inputs.VolumeReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes a reference to a volume resource.
 * @property destinationPath The path within the container at which the volume should be mounted. Only valid path characters are allowed.
 * @property name Name of the volume being referenced.
 * @property readOnly The flag indicating whether the volume is read only. Default is 'false'.
 */
public data class VolumeReferenceArgs(
    public val destinationPath: Output<String>,
    public val name: Output<String>,
    public val readOnly: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabricmesh.inputs.VolumeReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabricmesh.inputs.VolumeReferenceArgs =
        com.pulumi.azurenative.servicefabricmesh.inputs.VolumeReferenceArgs.builder()
            .destinationPath(destinationPath.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .readOnly(readOnly?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VolumeReferenceArgs].
 */
@PulumiTagMarker
public class VolumeReferenceArgsBuilder internal constructor() {
    private var destinationPath: Output<String>? = null

    private var name: Output<String>? = null

    private var readOnly: Output<Boolean>? = null

    /**
     * @param value The path within the container at which the volume should be mounted. Only valid path characters are allowed.
     */
    @JvmName("kgbycuxwgmuircnv")
    public suspend fun destinationPath(`value`: Output<String>) {
        this.destinationPath = value
    }

    /**
     * @param value Name of the volume being referenced.
     */
    @JvmName("dbermuwvllkixmrm")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The flag indicating whether the volume is read only. Default is 'false'.
     */
    @JvmName("grqjibuijhqcfklf")
    public suspend fun readOnly(`value`: Output<Boolean>) {
        this.readOnly = value
    }

    /**
     * @param value The path within the container at which the volume should be mounted. Only valid path characters are allowed.
     */
    @JvmName("kklqwhrgsvdkurvu")
    public suspend fun destinationPath(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationPath = mapped
    }

    /**
     * @param value Name of the volume being referenced.
     */
    @JvmName("douoijuhncorabsv")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The flag indicating whether the volume is read only. Default is 'false'.
     */
    @JvmName("yphsgkwglixkawrh")
    public suspend fun readOnly(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readOnly = mapped
    }

    internal fun build(): VolumeReferenceArgs = VolumeReferenceArgs(
        destinationPath = destinationPath ?: throw PulumiNullFieldException("destinationPath"),
        name = name ?: throw PulumiNullFieldException("name"),
        readOnly = readOnly,
    )
}
