@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Describes the horizontal auto scaling mechanism that adds or removes replicas (containers or container groups).
 * @property kind Enumerates the mechanisms for auto scaling.
 * Expected value is 'AddRemoveReplica'.
 * @property maxCount Maximum number of containers (scale up won't be performed above this number).
 * @property minCount Minimum number of containers (scale down won't be performed below this number).
 * @property scaleIncrement Each time auto scaling is performed, this number of containers will be added or removed.
 */
public data class AddRemoveReplicaScalingMechanismResponse(
    public val kind: String,
    public val maxCount: Int,
    public val minCount: Int,
    public val scaleIncrement: Int,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicefabricmesh.outputs.AddRemoveReplicaScalingMechanismResponse):
            AddRemoveReplicaScalingMechanismResponse = AddRemoveReplicaScalingMechanismResponse(
            kind = javaType.kind(),
            maxCount = javaType.maxCount(),
            minCount = javaType.minCount(),
            scaleIncrement = javaType.scaleIncrement(),
        )
    }
}
