@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Diagnostics settings for Geneva.
 * @property accountName Azure Internal monitoring pipeline account.
 * @property autoKeyConfigUrl Azure Internal monitoring pipeline autokey associated with the certificate.
 * @property description A description of the sink.
 * @property fluentdConfigUrl Azure Internal monitoring agent fluentd configuration.
 * @property kind The kind of DiagnosticsSink.
 * Expected value is 'AzureInternalMonitoringPipeline'.
 * @property maConfigUrl Azure Internal monitoring agent configuration.
 * @property name Name of the sink. This value is referenced by DiagnosticsReferenceDescription
 * @property namespace Azure Internal monitoring pipeline account namespace.
 */
public data class AzureInternalMonitoringPipelineSinkDescriptionResponse(
    public val accountName: String? = null,
    public val autoKeyConfigUrl: String? = null,
    public val description: String? = null,
    public val fluentdConfigUrl: Any? = null,
    public val kind: String,
    public val maConfigUrl: String? = null,
    public val name: String? = null,
    public val namespace: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicefabricmesh.outputs.AzureInternalMonitoringPipelineSinkDescriptionResponse):
            AzureInternalMonitoringPipelineSinkDescriptionResponse =
            AzureInternalMonitoringPipelineSinkDescriptionResponse(
                accountName = javaType.accountName().map({ args0 -> args0 }).orElse(null),
                autoKeyConfigUrl = javaType.autoKeyConfigUrl().map({ args0 -> args0 }).orElse(null),
                description = javaType.description().map({ args0 -> args0 }).orElse(null),
                fluentdConfigUrl = javaType.fluentdConfigUrl().map({ args0 -> args0 }).orElse(null),
                kind = javaType.kind(),
                maConfigUrl = javaType.maConfigUrl().map({ args0 -> args0 }).orElse(null),
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
                namespace = javaType.namespace().map({ args0 -> args0 }).orElse(null),
            )
    }
}
