@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Describes the tcp configuration for external connectivity for this network.
 * @property destination Describes destination endpoint for routing traffic.
 * @property name tcp gateway config name.
 * @property port Specifies the port at which the service endpoint below needs to be exposed.
 */
public data class TcpConfigResponse(
    public val destination: GatewayDestinationResponse,
    public val name: String,
    public val port: Int,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicefabricmesh.outputs.TcpConfigResponse):
            TcpConfigResponse = TcpConfigResponse(
            destination = javaType.destination().let({ args0 ->
                com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.GatewayDestinationResponse.Companion.toKotlin(args0)
            }),
            name = javaType.name(),
            port = javaType.port(),
        )
    }
}
