@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Describes a reference to a volume resource.
 * @property destinationPath The path within the container at which the volume should be mounted. Only valid path characters are allowed.
 * @property name Name of the volume being referenced.
 * @property readOnly The flag indicating whether the volume is read only. Default is 'false'.
 */
public data class VolumeReferenceResponse(
    public val destinationPath: String,
    public val name: String,
    public val readOnly: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicefabricmesh.outputs.VolumeReferenceResponse):
            VolumeReferenceResponse = VolumeReferenceResponse(
            destinationPath = javaType.destinationPath(),
            name = javaType.name(),
            readOnly = javaType.readOnly().map({ args0 -> args0 }).orElse(null),
        )
    }
}
