@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin.inputs

import com.pulumi.azurenative.servicelinker.inputs.FirewallRulesArgs.builder
import com.pulumi.azurenative.servicelinker.kotlin.enums.AllowType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Target service's firewall rules. to allow connections from source service.
 * @property azureServices Allow Azure services to access the target service if true.
 * @property callerClientIP Allow caller client IP to access the target service if true. the property is used when connecting local application to target service.
 * @property ipRanges This value specifies the set of IP addresses or IP address ranges in CIDR form to be included as the allowed list of client IPs for a given database account.
 */
public data class FirewallRulesArgs(
    public val azureServices: Output<Either<String, AllowType>>? = null,
    public val callerClientIP: Output<Either<String, AllowType>>? = null,
    public val ipRanges: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicelinker.inputs.FirewallRulesArgs> {
    override fun toJava(): com.pulumi.azurenative.servicelinker.inputs.FirewallRulesArgs =
        com.pulumi.azurenative.servicelinker.inputs.FirewallRulesArgs.builder()
            .azureServices(
                azureServices?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .callerClientIP(
                callerClientIP?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .ipRanges(ipRanges?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [FirewallRulesArgs].
 */
@PulumiTagMarker
public class FirewallRulesArgsBuilder internal constructor() {
    private var azureServices: Output<Either<String, AllowType>>? = null

    private var callerClientIP: Output<Either<String, AllowType>>? = null

    private var ipRanges: Output<List<String>>? = null

    /**
     * @param value Allow Azure services to access the target service if true.
     */
    @JvmName("pwjhveyqwacqgmmp")
    public suspend fun azureServices(`value`: Output<Either<String, AllowType>>) {
        this.azureServices = value
    }

    /**
     * @param value Allow caller client IP to access the target service if true. the property is used when connecting local application to target service.
     */
    @JvmName("tvggbathfgsnjhfm")
    public suspend fun callerClientIP(`value`: Output<Either<String, AllowType>>) {
        this.callerClientIP = value
    }

    /**
     * @param value This value specifies the set of IP addresses or IP address ranges in CIDR form to be included as the allowed list of client IPs for a given database account.
     */
    @JvmName("cuvfybxsgjupnrym")
    public suspend fun ipRanges(`value`: Output<List<String>>) {
        this.ipRanges = value
    }

    @JvmName("vqaxnsibgsimsvtw")
    public suspend fun ipRanges(vararg values: Output<String>) {
        this.ipRanges = Output.all(values.asList())
    }

    /**
     * @param values This value specifies the set of IP addresses or IP address ranges in CIDR form to be included as the allowed list of client IPs for a given database account.
     */
    @JvmName("jfnbbpikqqyuqgsn")
    public suspend fun ipRanges(values: List<Output<String>>) {
        this.ipRanges = Output.all(values)
    }

    /**
     * @param value Allow Azure services to access the target service if true.
     */
    @JvmName("jgcvurgfpjilnxvg")
    public suspend fun azureServices(`value`: Either<String, AllowType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureServices = mapped
    }

    /**
     * @param value Allow Azure services to access the target service if true.
     */
    @JvmName("ojhdfdtjnqqvaeih")
    public fun azureServices(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AllowType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureServices = mapped
    }

    /**
     * @param value Allow Azure services to access the target service if true.
     */
    @JvmName("kynanjhshpphsolf")
    public fun azureServices(`value`: AllowType) {
        val toBeMapped = Either.ofRight<String, AllowType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureServices = mapped
    }

    /**
     * @param value Allow caller client IP to access the target service if true. the property is used when connecting local application to target service.
     */
    @JvmName("apdpamithbqdtiyn")
    public suspend fun callerClientIP(`value`: Either<String, AllowType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.callerClientIP = mapped
    }

    /**
     * @param value Allow caller client IP to access the target service if true. the property is used when connecting local application to target service.
     */
    @JvmName("psfxwfmdemorkoib")
    public fun callerClientIP(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AllowType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.callerClientIP = mapped
    }

    /**
     * @param value Allow caller client IP to access the target service if true. the property is used when connecting local application to target service.
     */
    @JvmName("mgmrmfttcbanhaeb")
    public fun callerClientIP(`value`: AllowType) {
        val toBeMapped = Either.ofRight<String, AllowType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.callerClientIP = mapped
    }

    /**
     * @param value This value specifies the set of IP addresses or IP address ranges in CIDR form to be included as the allowed list of client IPs for a given database account.
     */
    @JvmName("qluemwwxbmyhhbuw")
    public suspend fun ipRanges(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipRanges = mapped
    }

    /**
     * @param values This value specifies the set of IP addresses or IP address ranges in CIDR form to be included as the allowed list of client IPs for a given database account.
     */
    @JvmName("gyrsntmuipfgmdlw")
    public suspend fun ipRanges(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipRanges = mapped
    }

    internal fun build(): FirewallRulesArgs = FirewallRulesArgs(
        azureServices = azureServices,
        callerClientIP = callerClientIP,
        ipRanges = ipRanges,
    )
}
