@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin.inputs

import com.pulumi.azurenative.servicelinker.inputs.ListLinkerConfigurationsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property linkerName The name Linker resource.
 * @property resourceUri The fully qualified Azure Resource manager identifier of the resource to be connected.
 */
public data class ListLinkerConfigurationsPlainArgs(
    public val linkerName: String,
    public val resourceUri: String,
) : ConvertibleToJava<com.pulumi.azurenative.servicelinker.inputs.ListLinkerConfigurationsPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.servicelinker.inputs.ListLinkerConfigurationsPlainArgs =
        com.pulumi.azurenative.servicelinker.inputs.ListLinkerConfigurationsPlainArgs.builder()
            .linkerName(linkerName.let({ args0 -> args0 }))
            .resourceUri(resourceUri.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListLinkerConfigurationsPlainArgs].
 */
@PulumiTagMarker
public class ListLinkerConfigurationsPlainArgsBuilder internal constructor() {
    private var linkerName: String? = null

    private var resourceUri: String? = null

    /**
     * @param value The name Linker resource.
     */
    @JvmName("tfttkosesfpmrcdw")
    public suspend fun linkerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.linkerName = mapped
    }

    /**
     * @param value The fully qualified Azure Resource manager identifier of the resource to be connected.
     */
    @JvmName("qclgfcrsheqyvmss")
    public suspend fun resourceUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceUri = mapped
    }

    internal fun build(): ListLinkerConfigurationsPlainArgs = ListLinkerConfigurationsPlainArgs(
        linkerName = linkerName ?: throw PulumiNullFieldException("linkerName"),
        resourceUri = resourceUri ?: throw PulumiNullFieldException("resourceUri"),
    )
}
