@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin.inputs

import com.pulumi.azurenative.servicelinker.inputs.VNetSolutionArgs.builder
import com.pulumi.azurenative.servicelinker.kotlin.enums.DeleteOrUpdateBehavior
import com.pulumi.azurenative.servicelinker.kotlin.enums.VNetSolutionType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The VNet solution for linker
 * @property deleteOrUpdateBehavior Indicates whether to clean up previous operation when Linker is updating or deleting
 * @property type Type of VNet solution.
 */
public data class VNetSolutionArgs(
    public val deleteOrUpdateBehavior: Output<Either<String, DeleteOrUpdateBehavior>>? = null,
    public val type: Output<Either<String, VNetSolutionType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicelinker.inputs.VNetSolutionArgs> {
    override fun toJava(): com.pulumi.azurenative.servicelinker.inputs.VNetSolutionArgs =
        com.pulumi.azurenative.servicelinker.inputs.VNetSolutionArgs.builder()
            .deleteOrUpdateBehavior(
                deleteOrUpdateBehavior?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [VNetSolutionArgs].
 */
@PulumiTagMarker
public class VNetSolutionArgsBuilder internal constructor() {
    private var deleteOrUpdateBehavior: Output<Either<String, DeleteOrUpdateBehavior>>? = null

    private var type: Output<Either<String, VNetSolutionType>>? = null

    /**
     * @param value Indicates whether to clean up previous operation when Linker is updating or deleting
     */
    @JvmName("bytiwciykxxajcoh")
    public suspend
    fun deleteOrUpdateBehavior(`value`: Output<Either<String, DeleteOrUpdateBehavior>>) {
        this.deleteOrUpdateBehavior = value
    }

    /**
     * @param value Type of VNet solution.
     */
    @JvmName("yvaivqwhtemgpvbm")
    public suspend fun type(`value`: Output<Either<String, VNetSolutionType>>) {
        this.type = value
    }

    /**
     * @param value Indicates whether to clean up previous operation when Linker is updating or deleting
     */
    @JvmName("ulpnedttrbutrwls")
    public suspend fun deleteOrUpdateBehavior(`value`: Either<String, DeleteOrUpdateBehavior>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteOrUpdateBehavior = mapped
    }

    /**
     * @param value Indicates whether to clean up previous operation when Linker is updating or deleting
     */
    @JvmName("vdlvlrkgbaibftve")
    public fun deleteOrUpdateBehavior(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DeleteOrUpdateBehavior>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deleteOrUpdateBehavior = mapped
    }

    /**
     * @param value Indicates whether to clean up previous operation when Linker is updating or deleting
     */
    @JvmName("cffrmnbamsodmlfh")
    public fun deleteOrUpdateBehavior(`value`: DeleteOrUpdateBehavior) {
        val toBeMapped = Either.ofRight<String, DeleteOrUpdateBehavior>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deleteOrUpdateBehavior = mapped
    }

    /**
     * @param value Type of VNet solution.
     */
    @JvmName("sisatkunbdvuegxc")
    public suspend fun type(`value`: Either<String, VNetSolutionType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Type of VNet solution.
     */
    @JvmName("qglhsibohwfgacly")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VNetSolutionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Type of VNet solution.
     */
    @JvmName("iqqryrlxghtxdvvs")
    public fun type(`value`: VNetSolutionType) {
        val toBeMapped = Either.ofRight<String, VNetSolutionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): VNetSolutionArgs = VNetSolutionArgs(
        deleteOrUpdateBehavior = deleteOrUpdateBehavior,
        type = type,
    )
}
