@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The azure resource info when target service type is AzureResource
 * @property id The Id of azure resource.
 * @property resourceProperties The azure resource connection related properties.
 * @property type The target service type.
 * Expected value is 'AzureResource'.
 */
public data class AzureResourceResponse(
    public val id: String? = null,
    public val resourceProperties: AzureKeyVaultPropertiesResponse? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicelinker.outputs.AzureResourceResponse):
            AzureResourceResponse = AzureResourceResponse(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            resourceProperties = javaType.resourceProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicelinker.kotlin.outputs.AzureKeyVaultPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
