@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The secret info when type is keyVaultSecretUri. It's for scenario that user provides a secret stored in user's keyvault and source is Web App, Spring Cloud or Container App.
 * @property secretType The secret type.
 * Expected value is 'keyVaultSecretUri'.
 * @property value URI to the keyvault secret
 */
public data class KeyVaultSecretUriSecretInfoResponse(
    public val secretType: String,
    public val `value`: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicelinker.outputs.KeyVaultSecretUriSecretInfoResponse):
            KeyVaultSecretUriSecretInfoResponse = KeyVaultSecretUriSecretInfoResponse(
            secretType = javaType.secretType(),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
