@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * An option to store secret value in secure place
 * @property keyVaultId The key vault id to store secret
 * @property keyVaultSecretName The key vault secret name to store secret, only valid when storing one secret
 */
public data class SecretStoreResponse(
    public val keyVaultId: String? = null,
    public val keyVaultSecretName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicelinker.outputs.SecretStoreResponse):
            SecretStoreResponse = SecretStoreResponse(
            keyVaultId = javaType.keyVaultId().map({ args0 -> args0 }).orElse(null),
            keyVaultSecretName = javaType.keyVaultSecretName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
