@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicenetworking.kotlin

import com.pulumi.azurenative.servicenetworking.kotlin.outputs.AssociationSubnetResponse
import com.pulumi.azurenative.servicenetworking.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.servicenetworking.kotlin.outputs.AssociationSubnetResponse.Companion.toKotlin as associationSubnetResponseToKotlin
import com.pulumi.azurenative.servicenetworking.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [AssociationsInterface].
 */
@PulumiTagMarker
public class AssociationsInterfaceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AssociationsInterfaceArgs = AssociationsInterfaceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AssociationsInterfaceArgsBuilder.() -> Unit) {
        val builder = AssociationsInterfaceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AssociationsInterface {
        val builtJavaResource =
            com.pulumi.azurenative.servicenetworking.AssociationsInterface(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AssociationsInterface(builtJavaResource)
    }
}

/**
 * Association Subresource of Traffic Controller
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2022-10-01-preview.
 * Other available API versions: 2022-10-01-preview, 2023-11-01.
 * ## Example Usage
 * ### Put Association
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var associationsInterface = new AzureNative.ServiceNetworking.AssociationsInterface("associationsInterface", new()
 *     {
 *         AssociationName = "as1",
 *         AssociationType = "subnets",
 *         Location = "NorthCentralUS",
 *         ResourceGroupName = "rg1",
 *         Subnet = new AzureNative.ServiceNetworking.Inputs.AssociationSubnetArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet-tc/subnets/tc-subnet",
 *         },
 *         TrafficControllerName = "tc1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicenetworking/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicenetworking.NewAssociationsInterface(ctx, "associationsInterface", &servicenetworking.AssociationsInterfaceArgs{
 * 			AssociationName:   pulumi.String("as1"),
 * 			AssociationType:   pulumi.String("subnets"),
 * 			Location:          pulumi.String("NorthCentralUS"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Subnet: &servicenetworking.AssociationSubnetArgs{
 * 				Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet-tc/subnets/tc-subnet"),
 * 			},
 * 			TrafficControllerName: pulumi.String("tc1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicenetworking.AssociationsInterface;
 * import com.pulumi.azurenative.servicenetworking.AssociationsInterfaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var associationsInterface = new AssociationsInterface("associationsInterface", AssociationsInterfaceArgs.builder()
 *             .associationName("as1")
 *             .associationType("subnets")
 *             .location("NorthCentralUS")
 *             .resourceGroupName("rg1")
 *             .subnet(Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet-tc/subnets/tc-subnet"))
 *             .trafficControllerName("tc1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:servicenetworking:AssociationsInterface associatedvnet-1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceNetworking/trafficControllers/{trafficControllerName}/associations/{associationName}
 * ```
 */
public class AssociationsInterface internal constructor(
    override val javaResource: com.pulumi.azurenative.servicenetworking.AssociationsInterface,
) : KotlinCustomResource(javaResource, AssociationsInterfaceMapper) {
    /**
     * Association Type
     */
    public val associationType: Output<String>
        get() = javaResource.associationType().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning State of Traffic Controller Association Resource
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Association Subnet
     */
    public val subnet: Output<AssociationSubnetResponse>?
        get() = javaResource.subnet().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    associationSubnetResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AssociationsInterfaceMapper : ResourceMapper<AssociationsInterface> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.servicenetworking.AssociationsInterface::class == javaResource::class

    override fun map(javaResource: Resource): AssociationsInterface =
        AssociationsInterface(
            javaResource as
                com.pulumi.azurenative.servicenetworking.AssociationsInterface,
        )
}

/**
 * @see [AssociationsInterface].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AssociationsInterface].
 */
public suspend fun associationsInterface(
    name: String,
    block: suspend AssociationsInterfaceResourceBuilder.() -> Unit,
): AssociationsInterface {
    val builder = AssociationsInterfaceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AssociationsInterface].
 * @param name The _unique_ name of the resulting resource.
 */
public fun associationsInterface(name: String): AssociationsInterface {
    val builder = AssociationsInterfaceResourceBuilder()
    builder.name(name)
    return builder.build()
}
