@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicenetworking.kotlin

import com.pulumi.azurenative.servicenetworking.AssociationsInterfaceArgs.builder
import com.pulumi.azurenative.servicenetworking.kotlin.enums.AssociationType
import com.pulumi.azurenative.servicenetworking.kotlin.inputs.AssociationSubnetArgs
import com.pulumi.azurenative.servicenetworking.kotlin.inputs.AssociationSubnetArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Association Subresource of Traffic Controller
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2022-10-01-preview.
 * Other available API versions: 2022-10-01-preview, 2023-11-01.
 * ## Example Usage
 * ### Put Association
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var associationsInterface = new AzureNative.ServiceNetworking.AssociationsInterface("associationsInterface", new()
 *     {
 *         AssociationName = "as1",
 *         AssociationType = "subnets",
 *         Location = "NorthCentralUS",
 *         ResourceGroupName = "rg1",
 *         Subnet = new AzureNative.ServiceNetworking.Inputs.AssociationSubnetArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet-tc/subnets/tc-subnet",
 *         },
 *         TrafficControllerName = "tc1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicenetworking/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicenetworking.NewAssociationsInterface(ctx, "associationsInterface", &servicenetworking.AssociationsInterfaceArgs{
 * 			AssociationName:   pulumi.String("as1"),
 * 			AssociationType:   pulumi.String("subnets"),
 * 			Location:          pulumi.String("NorthCentralUS"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Subnet: &servicenetworking.AssociationSubnetArgs{
 * 				Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet-tc/subnets/tc-subnet"),
 * 			},
 * 			TrafficControllerName: pulumi.String("tc1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicenetworking.AssociationsInterface;
 * import com.pulumi.azurenative.servicenetworking.AssociationsInterfaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var associationsInterface = new AssociationsInterface("associationsInterface", AssociationsInterfaceArgs.builder()
 *             .associationName("as1")
 *             .associationType("subnets")
 *             .location("NorthCentralUS")
 *             .resourceGroupName("rg1")
 *             .subnet(Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet-tc/subnets/tc-subnet"))
 *             .trafficControllerName("tc1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:servicenetworking:AssociationsInterface associatedvnet-1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceNetworking/trafficControllers/{trafficControllerName}/associations/{associationName}
 * ```
 * @property associationName Name of Association
 * @property associationType Association Type
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property subnet Association Subnet
 * @property tags Resource tags.
 * @property trafficControllerName traffic controller name for path
 */
public data class AssociationsInterfaceArgs(
    public val associationName: Output<String>? = null,
    public val associationType: Output<Either<String, AssociationType>>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val subnet: Output<AssociationSubnetArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val trafficControllerName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicenetworking.AssociationsInterfaceArgs> {
    override fun toJava(): com.pulumi.azurenative.servicenetworking.AssociationsInterfaceArgs =
        com.pulumi.azurenative.servicenetworking.AssociationsInterfaceArgs.builder()
            .associationName(associationName?.applyValue({ args0 -> args0 }))
            .associationType(
                associationType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .subnet(subnet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .trafficControllerName(trafficControllerName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AssociationsInterfaceArgs].
 */
@PulumiTagMarker
public class AssociationsInterfaceArgsBuilder internal constructor() {
    private var associationName: Output<String>? = null

    private var associationType: Output<Either<String, AssociationType>>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var subnet: Output<AssociationSubnetArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var trafficControllerName: Output<String>? = null

    /**
     * @param value Name of Association
     */
    @JvmName("jwviivfglvrwtlrw")
    public suspend fun associationName(`value`: Output<String>) {
        this.associationName = value
    }

    /**
     * @param value Association Type
     */
    @JvmName("qoemrydwwklhnofu")
    public suspend fun associationType(`value`: Output<Either<String, AssociationType>>) {
        this.associationType = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("hgsuiadtemujqrag")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("eoebpeedahsbrahi")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Association Subnet
     */
    @JvmName("tonrogwxpxwlcnhw")
    public suspend fun subnet(`value`: Output<AssociationSubnetArgs>) {
        this.subnet = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("gtmepmyqvfrseylc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value traffic controller name for path
     */
    @JvmName("wolrjsarnmfakcgb")
    public suspend fun trafficControllerName(`value`: Output<String>) {
        this.trafficControllerName = value
    }

    /**
     * @param value Name of Association
     */
    @JvmName("xdyxqqfxkobdlwkm")
    public suspend fun associationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.associationName = mapped
    }

    /**
     * @param value Association Type
     */
    @JvmName("efkcsfggxskqlccd")
    public suspend fun associationType(`value`: Either<String, AssociationType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.associationType = mapped
    }

    /**
     * @param value Association Type
     */
    @JvmName("oappxennvdwdjtul")
    public fun associationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AssociationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.associationType = mapped
    }

    /**
     * @param value Association Type
     */
    @JvmName("rhshpncppiaaytet")
    public fun associationType(`value`: AssociationType) {
        val toBeMapped = Either.ofRight<String, AssociationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.associationType = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("syfqnoohfvabxbdc")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("patehkbmnksegdae")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Association Subnet
     */
    @JvmName("nqhwfbldbhcejnvp")
    public suspend fun subnet(`value`: AssociationSubnetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnet = mapped
    }

    /**
     * @param argument Association Subnet
     */
    @JvmName("oijosrdwhmlejgrr")
    public suspend fun subnet(argument: suspend AssociationSubnetArgsBuilder.() -> Unit) {
        val toBeMapped = AssociationSubnetArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.subnet = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("goefdaobdwlhaksx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("wwffuvbldknijgoq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value traffic controller name for path
     */
    @JvmName("besdptqijdpsqcau")
    public suspend fun trafficControllerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trafficControllerName = mapped
    }

    internal fun build(): AssociationsInterfaceArgs = AssociationsInterfaceArgs(
        associationName = associationName,
        associationType = associationType,
        location = location,
        resourceGroupName = resourceGroupName,
        subnet = subnet,
        tags = tags,
        trafficControllerName = trafficControllerName,
    )
}
