@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicenetworking.kotlin

import com.pulumi.azurenative.servicenetworking.kotlin.outputs.ResourceIdResponse
import com.pulumi.azurenative.servicenetworking.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.servicenetworking.kotlin.outputs.ResourceIdResponse.Companion.toKotlin as resourceIdResponseToKotlin
import com.pulumi.azurenative.servicenetworking.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [TrafficControllerInterface].
 */
@PulumiTagMarker
public class TrafficControllerInterfaceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TrafficControllerInterfaceArgs = TrafficControllerInterfaceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TrafficControllerInterfaceArgsBuilder.() -> Unit) {
        val builder = TrafficControllerInterfaceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): TrafficControllerInterface {
        val builtJavaResource =
            com.pulumi.azurenative.servicenetworking.TrafficControllerInterface(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return TrafficControllerInterface(builtJavaResource)
    }
}

/**
 * Concrete tracked resource types can be created by aliasing this type using a specific property type.
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2022-10-01-preview.
 * Other available API versions: 2022-10-01-preview, 2023-11-01.
 * ## Example Usage
 * ### Put Traffic Controller
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var trafficControllerInterface = new AzureNative.ServiceNetworking.TrafficControllerInterface("trafficControllerInterface", new()
 *     {
 *         Location = "NorthCentralUS",
 *         ResourceGroupName = "rg1",
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *         TrafficControllerName = "tc1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicenetworking/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicenetworking.NewTrafficControllerInterface(ctx, "trafficControllerInterface", &servicenetworking.TrafficControllerInterfaceArgs{
 * 			Location:          pulumi.String("NorthCentralUS"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			TrafficControllerName: pulumi.String("tc1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicenetworking.TrafficControllerInterface;
 * import com.pulumi.azurenative.servicenetworking.TrafficControllerInterfaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var trafficControllerInterface = new TrafficControllerInterface("trafficControllerInterface", TrafficControllerInterfaceArgs.builder()
 *             .location("NorthCentralUS")
 *             .resourceGroupName("rg1")
 *             .tags(Map.of("key1", "value1"))
 *             .trafficControllerName("tc1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:servicenetworking:TrafficControllerInterface tc1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceNetworking/trafficControllers/{trafficControllerName}
 * ```
 */
public class TrafficControllerInterface internal constructor(
    override val javaResource: com.pulumi.azurenative.servicenetworking.TrafficControllerInterface,
) : KotlinCustomResource(javaResource, TrafficControllerInterfaceMapper) {
    /**
     * Associations References List
     */
    public val associations: Output<List<ResourceIdResponse>>
        get() = javaResource.associations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resourceIdResponseToKotlin(args0)
                })
            })
        })

    /**
     * Configuration Endpoints.
     */
    public val configurationEndpoints: Output<List<String>>
        get() = javaResource.configurationEndpoints().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Frontends References List
     */
    public val frontends: Output<List<ResourceIdResponse>>
        get() = javaResource.frontends().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resourceIdResponseToKotlin(args0)
                })
            })
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object TrafficControllerInterfaceMapper : ResourceMapper<TrafficControllerInterface> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.servicenetworking.TrafficControllerInterface::class == javaResource::class

    override fun map(javaResource: Resource): TrafficControllerInterface =
        TrafficControllerInterface(
            javaResource as
                com.pulumi.azurenative.servicenetworking.TrafficControllerInterface,
        )
}

/**
 * @see [TrafficControllerInterface].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TrafficControllerInterface].
 */
public suspend fun trafficControllerInterface(
    name: String,
    block: suspend TrafficControllerInterfaceResourceBuilder.() -> Unit,
):
    TrafficControllerInterface {
    val builder = TrafficControllerInterfaceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TrafficControllerInterface].
 * @param name The _unique_ name of the resulting resource.
 */
public fun trafficControllerInterface(name: String): TrafficControllerInterface {
    val builder = TrafficControllerInterfaceResourceBuilder()
    builder.name(name)
    return builder.build()
}
