@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.signalrservice.kotlin

import com.pulumi.azurenative.signalrservice.SignalRArgs.builder
import com.pulumi.azurenative.signalrservice.kotlin.enums.ServiceKind
import com.pulumi.azurenative.signalrservice.kotlin.inputs.LiveTraceConfigurationArgs
import com.pulumi.azurenative.signalrservice.kotlin.inputs.LiveTraceConfigurationArgsBuilder
import com.pulumi.azurenative.signalrservice.kotlin.inputs.ManagedIdentityArgs
import com.pulumi.azurenative.signalrservice.kotlin.inputs.ManagedIdentityArgsBuilder
import com.pulumi.azurenative.signalrservice.kotlin.inputs.ResourceLogConfigurationArgs
import com.pulumi.azurenative.signalrservice.kotlin.inputs.ResourceLogConfigurationArgsBuilder
import com.pulumi.azurenative.signalrservice.kotlin.inputs.ResourceSkuArgs
import com.pulumi.azurenative.signalrservice.kotlin.inputs.ResourceSkuArgsBuilder
import com.pulumi.azurenative.signalrservice.kotlin.inputs.ServerlessSettingsArgs
import com.pulumi.azurenative.signalrservice.kotlin.inputs.ServerlessSettingsArgsBuilder
import com.pulumi.azurenative.signalrservice.kotlin.inputs.ServerlessUpstreamSettingsArgs
import com.pulumi.azurenative.signalrservice.kotlin.inputs.ServerlessUpstreamSettingsArgsBuilder
import com.pulumi.azurenative.signalrservice.kotlin.inputs.SignalRCorsSettingsArgs
import com.pulumi.azurenative.signalrservice.kotlin.inputs.SignalRCorsSettingsArgsBuilder
import com.pulumi.azurenative.signalrservice.kotlin.inputs.SignalRFeatureArgs
import com.pulumi.azurenative.signalrservice.kotlin.inputs.SignalRFeatureArgsBuilder
import com.pulumi.azurenative.signalrservice.kotlin.inputs.SignalRNetworkACLsArgs
import com.pulumi.azurenative.signalrservice.kotlin.inputs.SignalRNetworkACLsArgsBuilder
import com.pulumi.azurenative.signalrservice.kotlin.inputs.SignalRTlsSettingsArgs
import com.pulumi.azurenative.signalrservice.kotlin.inputs.SignalRTlsSettingsArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A class represent a resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-05-01.
 * Other available API versions: 2018-10-01, 2023-03-01-preview, 2023-06-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### SignalR_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var signalR = new AzureNative.SignalRService.SignalR("signalR", new()
 *     {
 *         Cors = new AzureNative.SignalRService.Inputs.SignalRCorsSettingsArgs
 *         {
 *             AllowedOrigins = new[]
 *             {
 *                 "https://foo.com",
 *                 "https://bar.com",
 *             },
 *         },
 *         DisableAadAuth = false,
 *         DisableLocalAuth = false,
 *         Features = new[]
 *         {
 *             new AzureNative.SignalRService.Inputs.SignalRFeatureArgs
 *             {
 *                 Flag = "ServiceMode",
 *                 Properties = null,
 *                 Value = "Serverless",
 *             },
 *             new AzureNative.SignalRService.Inputs.SignalRFeatureArgs
 *             {
 *                 Flag = "EnableConnectivityLogs",
 *                 Properties = null,
 *                 Value = "True",
 *             },
 *             new AzureNative.SignalRService.Inputs.SignalRFeatureArgs
 *             {
 *                 Flag = "EnableMessagingLogs",
 *                 Properties = null,
 *                 Value = "False",
 *             },
 *             new AzureNative.SignalRService.Inputs.SignalRFeatureArgs
 *             {
 *                 Flag = "EnableLiveTrace",
 *                 Properties = null,
 *                 Value = "False",
 *             },
 *         },
 *         Identity = new AzureNative.SignalRService.Inputs.ManagedIdentityArgs
 *         {
 *             Type = "SystemAssigned",
 *         },
 *         Kind = "SignalR",
 *         LiveTraceConfiguration = new AzureNative.SignalRService.Inputs.LiveTraceConfigurationArgs
 *         {
 *             Categories = new[]
 *             {
 *                 new AzureNative.SignalRService.Inputs.LiveTraceCategoryArgs
 *                 {
 *                     Enabled = "true",
 *                     Name = "ConnectivityLogs",
 *                 },
 *             },
 *             Enabled = "false",
 *         },
 *         Location = "eastus",
 *         NetworkACLs = new AzureNative.SignalRService.Inputs.SignalRNetworkACLsArgs
 *         {
 *             DefaultAction = "Deny",
 *             PrivateEndpoints = new[]
 *             {
 *                 new AzureNative.SignalRService.Inputs.PrivateEndpointACLArgs
 *                 {
 *                     Allow = new[]
 *                     {
 *                         "ServerConnection",
 *                     },
 *                     Name = "mysignalrservice.1fa229cd-bf3f-47f0-8c49-afb36723997e",
 *                 },
 *             },
 *             PublicNetwork = new AzureNative.SignalRService.Inputs.NetworkACLArgs
 *             {
 *                 Allow = new[]
 *                 {
 *                     "ClientConnection",
 *                 },
 *             },
 *         },
 *         PublicNetworkAccess = "Enabled",
 *         ResourceGroupName = "myResourceGroup",
 *         ResourceName = "mySignalRService",
 *         Serverless = new AzureNative.SignalRService.Inputs.ServerlessSettingsArgs
 *         {
 *             ConnectionTimeoutInSeconds = 5,
 *         },
 *         Sku = new AzureNative.SignalRService.Inputs.ResourceSkuArgs
 *         {
 *             Capacity = 1,
 *             Name = "Premium_P1",
 *             Tier = "Premium",
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *         Tls = new AzureNative.SignalRService.Inputs.SignalRTlsSettingsArgs
 *         {
 *             ClientCertEnabled = false,
 *         },
 *         Upstream = new AzureNative.SignalRService.Inputs.ServerlessUpstreamSettingsArgs
 *         {
 *             Templates = new[]
 *             {
 *                 new AzureNative.SignalRService.Inputs.UpstreamTemplateArgs
 *                 {
 *                     Auth = new AzureNative.SignalRService.Inputs.UpstreamAuthSettingsArgs
 *                     {
 *                         ManagedIdentity = new AzureNative.SignalRService.Inputs.ManagedIdentitySettingsArgs
 *                         {
 *                             Resource = "api://example",
 *                         },
 *                         Type = "ManagedIdentity",
 *                     },
 *                     CategoryPattern = "*",
 *                     EventPattern = "connect,disconnect",
 *                     HubPattern = "*",
 *                     UrlTemplate = "https://example.com/chat/api/connect",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/signalrservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := signalrservice.NewSignalR(ctx, "signalR", &signalrservice.SignalRArgs{
 * Cors: &signalrservice.SignalRCorsSettingsArgs{
 * AllowedOrigins: pulumi.StringArray{
 * pulumi.String("https://foo.com"),
 * pulumi.String("https://bar.com"),
 * },
 * },
 * DisableAadAuth: pulumi.Bool(false),
 * DisableLocalAuth: pulumi.Bool(false),
 * Features: []signalrservice.SignalRFeatureArgs{
 * {
 * Flag: pulumi.String("ServiceMode"),
 * Properties: nil,
 * Value: pulumi.String("Serverless"),
 * },
 * {
 * Flag: pulumi.String("EnableConnectivityLogs"),
 * Properties: nil,
 * Value: pulumi.String("True"),
 * },
 * {
 * Flag: pulumi.String("EnableMessagingLogs"),
 * Properties: nil,
 * Value: pulumi.String("False"),
 * },
 * {
 * Flag: pulumi.String("EnableLiveTrace"),
 * Properties: nil,
 * Value: pulumi.String("False"),
 * },
 * },
 * Identity: &signalrservice.ManagedIdentityArgs{
 * Type: pulumi.String("SystemAssigned"),
 * },
 * Kind: pulumi.String("SignalR"),
 * LiveTraceConfiguration: signalrservice.LiveTraceConfigurationResponse{
 * Categories: signalrservice.LiveTraceCategoryArray{
 * &signalrservice.LiveTraceCategoryArgs{
 * Enabled: pulumi.String("true"),
 * Name: pulumi.String("ConnectivityLogs"),
 * },
 * },
 * Enabled: pulumi.String("false"),
 * },
 * Location: pulumi.String("eastus"),
 * NetworkACLs: signalrservice.SignalRNetworkACLsResponse{
 * DefaultAction: pulumi.String("Deny"),
 * PrivateEndpoints: signalrservice.PrivateEndpointACLArray{
 * &signalrservice.PrivateEndpointACLArgs{
 * Allow: pulumi.StringArray{
 * pulumi.String("ServerConnection"),
 * },
 * Name: pulumi.String("mysignalrservice.1fa229cd-bf3f-47f0-8c49-afb36723997e"),
 * },
 * },
 * PublicNetwork: &signalrservice.NetworkACLArgs{
 * Allow: pulumi.StringArray{
 * pulumi.String("ClientConnection"),
 * },
 * },
 * },
 * PublicNetworkAccess: pulumi.String("Enabled"),
 * ResourceGroupName: pulumi.String("myResourceGroup"),
 * ResourceName: pulumi.String("mySignalRService"),
 * Serverless: &signalrservice.ServerlessSettingsArgs{
 * ConnectionTimeoutInSeconds: pulumi.Int(5),
 * },
 * Sku: &signalrservice.ResourceSkuArgs{
 * Capacity: pulumi.Int(1),
 * Name: pulumi.String("Premium_P1"),
 * Tier: pulumi.String("Premium"),
 * },
 * Tags: pulumi.StringMap{
 * "key1": pulumi.String("value1"),
 * },
 * Tls: &signalrservice.SignalRTlsSettingsArgs{
 * ClientCertEnabled: pulumi.Bool(false),
 * },
 * Upstream: signalrservice.ServerlessUpstreamSettingsResponse{
 * Templates: signalrservice.UpstreamTemplateArray{
 * interface{}{
 * Auth: interface{}{
 * ManagedIdentity: &signalrservice.ManagedIdentitySettingsArgs{
 * Resource: pulumi.String("api://example"),
 * },
 * Type: pulumi.String("ManagedIdentity"),
 * },
 * CategoryPattern: pulumi.String("*"),
 * EventPattern: pulumi.String("connect,disconnect"),
 * HubPattern: pulumi.String("*"),
 * UrlTemplate: pulumi.String("https://example.com/chat/api/connect"),
 * },
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.signalrservice.SignalR;
 * import com.pulumi.azurenative.signalrservice.SignalRArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var signalR = new SignalR("signalR", SignalRArgs.builder()
 *             .cors(Map.of("allowedOrigins",
 *                 "https://foo.com",
 *                 "https://bar.com"))
 *             .disableAadAuth(false)
 *             .disableLocalAuth(false)
 *             .features(
 *                 Map.ofEntries(
 *                     Map.entry("flag", "ServiceMode"),
 *                     Map.entry("properties", ),
 *                     Map.entry("value", "Serverless")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("flag", "EnableConnectivityLogs"),
 *                     Map.entry("properties", ),
 *                     Map.entry("value", "True")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("flag", "EnableMessagingLogs"),
 *                     Map.entry("properties", ),
 *                     Map.entry("value", "False")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("flag", "EnableLiveTrace"),
 *                     Map.entry("properties", ),
 *                     Map.entry("value", "False")
 *                 ))
 *             .identity(Map.of("type", "SystemAssigned"))
 *             .kind("SignalR")
 *             .liveTraceConfiguration(Map.ofEntries(
 *                 Map.entry("categories", Map.ofEntries(
 *                     Map.entry("enabled", "true"),
 *                     Map.entry("name", "ConnectivityLogs")
 *                 )),
 *                 Map.entry("enabled", "false")
 *             ))
 *             .location("eastus")
 *             .networkACLs(Map.ofEntries(
 *                 Map.entry("defaultAction", "Deny"),
 *                 Map.entry("privateEndpoints", Map.ofEntries(
 *                     Map.entry("allow", "ServerConnection"),
 *                     Map.entry("name", "mysignalrservice.1fa229cd-bf3f-47f0-8c49-afb36723997e")
 *                 )),
 *                 Map.entry("publicNetwork", Map.of("allow", "ClientConnection"))
 *             ))
 *             .publicNetworkAccess("Enabled")
 *             .resourceGroupName("myResourceGroup")
 *             .resourceName("mySignalRService")
 *             .serverless(Map.of("connectionTimeoutInSeconds", 5))
 *             .sku(Map.ofEntries(
 *                 Map.entry("capacity", 1),
 *                 Map.entry("name", "Premium_P1"),
 *                 Map.entry("tier", "Premium")
 *             ))
 *             .tags(Map.of("key1", "value1"))
 *             .tls(Map.of("clientCertEnabled", false))
 *             .upstream(Map.of("templates", Map.ofEntries(
 *                 Map.entry("auth", Map.ofEntries(
 *                     Map.entry("managedIdentity", Map.of("resource", "api://example")),
 *                     Map.entry("type", "ManagedIdentity")
 *                 )),
 *                 Map.entry("categoryPattern", "*"),
 *                 Map.entry("eventPattern", "connect,disconnect"),
 *                 Map.entry("hubPattern", "*"),
 *                 Map.entry("urlTemplate", "https://example.com/chat/api/connect")
 *             )))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:signalrservice:SignalR mySignalRService /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SignalRService/signalR/{resourceName}
 * ```
 * @property cors Cross-Origin Resource Sharing (CORS) settings.
 * @property disableAadAuth DisableLocalAuth
 * Enable or disable aad auth
 * When set as true, connection with AuthType=aad won't work.
 * @property disableLocalAuth DisableLocalAuth
 * Enable or disable local auth with AccessKey
 * When set as true, connection with AccessKey=xxx won't work.
 * @property features List of the featureFlags.
 * FeatureFlags that are not included in the parameters for the update operation will not be modified.
 * And the response will only include featureFlags that are explicitly set.
 * When a featureFlag is not explicitly set, its globally default value will be used
 * But keep in mind, the default value doesn't mean "false". It varies in terms of different FeatureFlags.
 * @property identity A class represent managed identities used for request and response
 * @property kind The kind of the service, it can be SignalR or RawWebSockets
 * @property liveTraceConfiguration Live trace configuration of a Microsoft.SignalRService resource.
 * @property location The GEO location of the resource. e.g. West US | East US | North Central US | South Central US.
 * @property networkACLs Network ACLs for the resource
 * @property publicNetworkAccess Enable or disable public network access. Default to "Enabled".
 * When it's Enabled, network ACLs still apply.
 * When it's Disabled, public network access is always disabled no matter what you set in network ACLs.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property resourceLogConfiguration Resource log configuration of a Microsoft.SignalRService resource.
 * @property resourceName The name of the resource.
 * @property serverless Serverless settings.
 * @property sku The billing information of the resource.
 * @property tags Tags of the service which is a list of key value pairs that describe the resource.
 * @property tls TLS settings for the resource
 * @property upstream The settings for the Upstream when the service is in server-less mode.
 */
public data class SignalRArgs(
    public val cors: Output<SignalRCorsSettingsArgs>? = null,
    public val disableAadAuth: Output<Boolean>? = null,
    public val disableLocalAuth: Output<Boolean>? = null,
    public val features: Output<List<SignalRFeatureArgs>>? = null,
    public val identity: Output<ManagedIdentityArgs>? = null,
    public val kind: Output<Either<String, ServiceKind>>? = null,
    public val liveTraceConfiguration: Output<LiveTraceConfigurationArgs>? = null,
    public val location: Output<String>? = null,
    public val networkACLs: Output<SignalRNetworkACLsArgs>? = null,
    public val publicNetworkAccess: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceLogConfiguration: Output<ResourceLogConfigurationArgs>? = null,
    public val resourceName: Output<String>? = null,
    public val serverless: Output<ServerlessSettingsArgs>? = null,
    public val sku: Output<ResourceSkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val tls: Output<SignalRTlsSettingsArgs>? = null,
    public val upstream: Output<ServerlessUpstreamSettingsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.signalrservice.SignalRArgs> {
    override fun toJava(): com.pulumi.azurenative.signalrservice.SignalRArgs =
        com.pulumi.azurenative.signalrservice.SignalRArgs.builder()
            .cors(cors?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .disableAadAuth(disableAadAuth?.applyValue({ args0 -> args0 }))
            .disableLocalAuth(disableLocalAuth?.applyValue({ args0 -> args0 }))
            .features(
                features?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kind(
                kind?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .liveTraceConfiguration(
                liveTraceConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .networkACLs(networkACLs?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .publicNetworkAccess(publicNetworkAccess?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceLogConfiguration(
                resourceLogConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .serverless(serverless?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .tls(tls?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .upstream(upstream?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [SignalRArgs].
 */
@PulumiTagMarker
public class SignalRArgsBuilder internal constructor() {
    private var cors: Output<SignalRCorsSettingsArgs>? = null

    private var disableAadAuth: Output<Boolean>? = null

    private var disableLocalAuth: Output<Boolean>? = null

    private var features: Output<List<SignalRFeatureArgs>>? = null

    private var identity: Output<ManagedIdentityArgs>? = null

    private var kind: Output<Either<String, ServiceKind>>? = null

    private var liveTraceConfiguration: Output<LiveTraceConfigurationArgs>? = null

    private var location: Output<String>? = null

    private var networkACLs: Output<SignalRNetworkACLsArgs>? = null

    private var publicNetworkAccess: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceLogConfiguration: Output<ResourceLogConfigurationArgs>? = null

    private var resourceName: Output<String>? = null

    private var serverless: Output<ServerlessSettingsArgs>? = null

    private var sku: Output<ResourceSkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var tls: Output<SignalRTlsSettingsArgs>? = null

    private var upstream: Output<ServerlessUpstreamSettingsArgs>? = null

    /**
     * @param value Cross-Origin Resource Sharing (CORS) settings.
     */
    @JvmName("kdajkganfrxsifdu")
    public suspend fun cors(`value`: Output<SignalRCorsSettingsArgs>) {
        this.cors = value
    }

    /**
     * @param value DisableLocalAuth
     * Enable or disable aad auth
     * When set as true, connection with AuthType=aad won't work.
     */
    @JvmName("klbjothopiasxokc")
    public suspend fun disableAadAuth(`value`: Output<Boolean>) {
        this.disableAadAuth = value
    }

    /**
     * @param value DisableLocalAuth
     * Enable or disable local auth with AccessKey
     * When set as true, connection with AccessKey=xxx won't work.
     */
    @JvmName("iocysebinypsrgqj")
    public suspend fun disableLocalAuth(`value`: Output<Boolean>) {
        this.disableLocalAuth = value
    }

    /**
     * @param value List of the featureFlags.
     * FeatureFlags that are not included in the parameters for the update operation will not be modified.
     * And the response will only include featureFlags that are explicitly set.
     * When a featureFlag is not explicitly set, its globally default value will be used
     * But keep in mind, the default value doesn't mean "false". It varies in terms of different FeatureFlags.
     */
    @JvmName("mgqrslqxgnkjydkw")
    public suspend fun features(`value`: Output<List<SignalRFeatureArgs>>) {
        this.features = value
    }

    @JvmName("kkstrrhdgosewknb")
    public suspend fun features(vararg values: Output<SignalRFeatureArgs>) {
        this.features = Output.all(values.asList())
    }

    /**
     * @param values List of the featureFlags.
     * FeatureFlags that are not included in the parameters for the update operation will not be modified.
     * And the response will only include featureFlags that are explicitly set.
     * When a featureFlag is not explicitly set, its globally default value will be used
     * But keep in mind, the default value doesn't mean "false". It varies in terms of different FeatureFlags.
     */
    @JvmName("amsxnrppxblxiler")
    public suspend fun features(values: List<Output<SignalRFeatureArgs>>) {
        this.features = Output.all(values)
    }

    /**
     * @param value A class represent managed identities used for request and response
     */
    @JvmName("vatjnytuedldeqpw")
    public suspend fun identity(`value`: Output<ManagedIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The kind of the service, it can be SignalR or RawWebSockets
     */
    @JvmName("lonimmtcsyxrmetn")
    public suspend fun kind(`value`: Output<Either<String, ServiceKind>>) {
        this.kind = value
    }

    /**
     * @param value Live trace configuration of a Microsoft.SignalRService resource.
     */
    @JvmName("kkfmctafxfshyqmn")
    public suspend fun liveTraceConfiguration(`value`: Output<LiveTraceConfigurationArgs>) {
        this.liveTraceConfiguration = value
    }

    /**
     * @param value The GEO location of the resource. e.g. West US | East US | North Central US | South Central US.
     */
    @JvmName("vbybtpkofinxuffb")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Network ACLs for the resource
     */
    @JvmName("kbpfcaqblmvaapqi")
    public suspend fun networkACLs(`value`: Output<SignalRNetworkACLsArgs>) {
        this.networkACLs = value
    }

    /**
     * @param value Enable or disable public network access. Default to "Enabled".
     * When it's Enabled, network ACLs still apply.
     * When it's Disabled, public network access is always disabled no matter what you set in network ACLs.
     */
    @JvmName("qpjmgjatopnumnde")
    public suspend fun publicNetworkAccess(`value`: Output<String>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("hhaxhoacoosvlkcf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource log configuration of a Microsoft.SignalRService resource.
     */
    @JvmName("rfnvhybwdofpvdcy")
    public suspend fun resourceLogConfiguration(`value`: Output<ResourceLogConfigurationArgs>) {
        this.resourceLogConfiguration = value
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("cyhckysohucmynoq")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value Serverless settings.
     */
    @JvmName("vrmpwkbspkidhnqc")
    public suspend fun serverless(`value`: Output<ServerlessSettingsArgs>) {
        this.serverless = value
    }

    /**
     * @param value The billing information of the resource.
     */
    @JvmName("rjwwglgnctndnfys")
    public suspend fun sku(`value`: Output<ResourceSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Tags of the service which is a list of key value pairs that describe the resource.
     */
    @JvmName("nyvnosryrofesuef")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value TLS settings for the resource
     */
    @JvmName("xwdmvxbrriitxftc")
    public suspend fun tls(`value`: Output<SignalRTlsSettingsArgs>) {
        this.tls = value
    }

    /**
     * @param value The settings for the Upstream when the service is in server-less mode.
     */
    @JvmName("lbrjpkevbdejsjpq")
    public suspend fun upstream(`value`: Output<ServerlessUpstreamSettingsArgs>) {
        this.upstream = value
    }

    /**
     * @param value Cross-Origin Resource Sharing (CORS) settings.
     */
    @JvmName("bssdkdhippylohdr")
    public suspend fun cors(`value`: SignalRCorsSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cors = mapped
    }

    /**
     * @param argument Cross-Origin Resource Sharing (CORS) settings.
     */
    @JvmName("odaodgcovxbjlfla")
    public suspend fun cors(argument: suspend SignalRCorsSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = SignalRCorsSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cors = mapped
    }

    /**
     * @param value DisableLocalAuth
     * Enable or disable aad auth
     * When set as true, connection with AuthType=aad won't work.
     */
    @JvmName("cgblphhfntlmcfvy")
    public suspend fun disableAadAuth(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableAadAuth = mapped
    }

    /**
     * @param value DisableLocalAuth
     * Enable or disable local auth with AccessKey
     * When set as true, connection with AccessKey=xxx won't work.
     */
    @JvmName("tbiqeedyohkxpwlq")
    public suspend fun disableLocalAuth(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableLocalAuth = mapped
    }

    /**
     * @param value List of the featureFlags.
     * FeatureFlags that are not included in the parameters for the update operation will not be modified.
     * And the response will only include featureFlags that are explicitly set.
     * When a featureFlag is not explicitly set, its globally default value will be used
     * But keep in mind, the default value doesn't mean "false". It varies in terms of different FeatureFlags.
     */
    @JvmName("jdhqraxbltkeiers")
    public suspend fun features(`value`: List<SignalRFeatureArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.features = mapped
    }

    /**
     * @param argument List of the featureFlags.
     * FeatureFlags that are not included in the parameters for the update operation will not be modified.
     * And the response will only include featureFlags that are explicitly set.
     * When a featureFlag is not explicitly set, its globally default value will be used
     * But keep in mind, the default value doesn't mean "false". It varies in terms of different FeatureFlags.
     */
    @JvmName("xhrwccwcitpuvifv")
    public suspend fun features(argument: List<suspend SignalRFeatureArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SignalRFeatureArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.features = mapped
    }

    /**
     * @param argument List of the featureFlags.
     * FeatureFlags that are not included in the parameters for the update operation will not be modified.
     * And the response will only include featureFlags that are explicitly set.
     * When a featureFlag is not explicitly set, its globally default value will be used
     * But keep in mind, the default value doesn't mean "false". It varies in terms of different FeatureFlags.
     */
    @JvmName("lrxmaeeihsxwikau")
    public suspend fun features(vararg argument: suspend SignalRFeatureArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SignalRFeatureArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.features = mapped
    }

    /**
     * @param argument List of the featureFlags.
     * FeatureFlags that are not included in the parameters for the update operation will not be modified.
     * And the response will only include featureFlags that are explicitly set.
     * When a featureFlag is not explicitly set, its globally default value will be used
     * But keep in mind, the default value doesn't mean "false". It varies in terms of different FeatureFlags.
     */
    @JvmName("ckgyjdhntsrrxqjr")
    public suspend fun features(argument: suspend SignalRFeatureArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SignalRFeatureArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.features = mapped
    }

    /**
     * @param values List of the featureFlags.
     * FeatureFlags that are not included in the parameters for the update operation will not be modified.
     * And the response will only include featureFlags that are explicitly set.
     * When a featureFlag is not explicitly set, its globally default value will be used
     * But keep in mind, the default value doesn't mean "false". It varies in terms of different FeatureFlags.
     */
    @JvmName("qrhqeqwtyeadlquy")
    public suspend fun features(vararg values: SignalRFeatureArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.features = mapped
    }

    /**
     * @param value A class represent managed identities used for request and response
     */
    @JvmName("cpgjnwqmbelxssyc")
    public suspend fun identity(`value`: ManagedIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument A class represent managed identities used for request and response
     */
    @JvmName("hxyeblixhshfkywq")
    public suspend fun identity(argument: suspend ManagedIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The kind of the service, it can be SignalR or RawWebSockets
     */
    @JvmName("pfrvjipvaqbdkbwd")
    public suspend fun kind(`value`: Either<String, ServiceKind>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The kind of the service, it can be SignalR or RawWebSockets
     */
    @JvmName("ioyorutgkxrwiabl")
    public fun kind(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ServiceKind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The kind of the service, it can be SignalR or RawWebSockets
     */
    @JvmName("inowvjnqmqaauwkk")
    public fun kind(`value`: ServiceKind) {
        val toBeMapped = Either.ofRight<String, ServiceKind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Live trace configuration of a Microsoft.SignalRService resource.
     */
    @JvmName("smxdrvuympnnymkl")
    public suspend fun liveTraceConfiguration(`value`: LiveTraceConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.liveTraceConfiguration = mapped
    }

    /**
     * @param argument Live trace configuration of a Microsoft.SignalRService resource.
     */
    @JvmName("vjsfftcdfjphwgmh")
    public suspend
    fun liveTraceConfiguration(argument: suspend LiveTraceConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = LiveTraceConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.liveTraceConfiguration = mapped
    }

    /**
     * @param value The GEO location of the resource. e.g. West US | East US | North Central US | South Central US.
     */
    @JvmName("gqutmsejcdhubkcx")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Network ACLs for the resource
     */
    @JvmName("wlrmpvewbysnvwll")
    public suspend fun networkACLs(`value`: SignalRNetworkACLsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkACLs = mapped
    }

    /**
     * @param argument Network ACLs for the resource
     */
    @JvmName("qvxtvhokjhehirfh")
    public suspend fun networkACLs(argument: suspend SignalRNetworkACLsArgsBuilder.() -> Unit) {
        val toBeMapped = SignalRNetworkACLsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkACLs = mapped
    }

    /**
     * @param value Enable or disable public network access. Default to "Enabled".
     * When it's Enabled, network ACLs still apply.
     * When it's Disabled, public network access is always disabled no matter what you set in network ACLs.
     */
    @JvmName("aenwpcjecoxujpce")
    public suspend fun publicNetworkAccess(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("txhjgjglckfamhhm")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource log configuration of a Microsoft.SignalRService resource.
     */
    @JvmName("lmxaynkupbjfsrkj")
    public suspend fun resourceLogConfiguration(`value`: ResourceLogConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceLogConfiguration = mapped
    }

    /**
     * @param argument Resource log configuration of a Microsoft.SignalRService resource.
     */
    @JvmName("dsrxjmlywspycjaf")
    public suspend
    fun resourceLogConfiguration(argument: suspend ResourceLogConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceLogConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.resourceLogConfiguration = mapped
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("cluwelmxchbvkgnj")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value Serverless settings.
     */
    @JvmName("vmrkqbufqowmbper")
    public suspend fun serverless(`value`: ServerlessSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverless = mapped
    }

    /**
     * @param argument Serverless settings.
     */
    @JvmName("osadggiablmkiedw")
    public suspend fun serverless(argument: suspend ServerlessSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = ServerlessSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.serverless = mapped
    }

    /**
     * @param value The billing information of the resource.
     */
    @JvmName("pltdtbgjowxibnba")
    public suspend fun sku(`value`: ResourceSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The billing information of the resource.
     */
    @JvmName("jwlitbhffoooacel")
    public suspend fun sku(argument: suspend ResourceSkuArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceSkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Tags of the service which is a list of key value pairs that describe the resource.
     */
    @JvmName("wwdelsjhrrxsvcdr")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags of the service which is a list of key value pairs that describe the resource.
     */
    @JvmName("imwmrdvphugwyppl")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value TLS settings for the resource
     */
    @JvmName("tarsaphdvntdqhjm")
    public suspend fun tls(`value`: SignalRTlsSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tls = mapped
    }

    /**
     * @param argument TLS settings for the resource
     */
    @JvmName("kqnyaisldnjloqxe")
    public suspend fun tls(argument: suspend SignalRTlsSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = SignalRTlsSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tls = mapped
    }

    /**
     * @param value The settings for the Upstream when the service is in server-less mode.
     */
    @JvmName("kikqfchpvhpamddo")
    public suspend fun upstream(`value`: ServerlessUpstreamSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.upstream = mapped
    }

    /**
     * @param argument The settings for the Upstream when the service is in server-less mode.
     */
    @JvmName("ejmqpmagemjuvpec")
    public suspend fun upstream(argument: suspend ServerlessUpstreamSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = ServerlessUpstreamSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.upstream = mapped
    }

    internal fun build(): SignalRArgs = SignalRArgs(
        cors = cors,
        disableAadAuth = disableAadAuth,
        disableLocalAuth = disableLocalAuth,
        features = features,
        identity = identity,
        kind = kind,
        liveTraceConfiguration = liveTraceConfiguration,
        location = location,
        networkACLs = networkACLs,
        publicNetworkAccess = publicNetworkAccess,
        resourceGroupName = resourceGroupName,
        resourceLogConfiguration = resourceLogConfiguration,
        resourceName = resourceName,
        serverless = serverless,
        sku = sku,
        tags = tags,
        tls = tls,
        upstream = upstream,
    )
}
