@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.signalrservice.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Optional tier of this particular SKU. 'Standard' or 'Free'.
 * `Basic` is deprecated, use `Standard` instead.
 */
public enum class SignalRSkuTier(
    public val javaValue: com.pulumi.azurenative.signalrservice.enums.SignalRSkuTier,
) : ConvertibleToJava<com.pulumi.azurenative.signalrservice.enums.SignalRSkuTier> {
    Free(com.pulumi.azurenative.signalrservice.enums.SignalRSkuTier.Free),
    Basic(com.pulumi.azurenative.signalrservice.enums.SignalRSkuTier.Basic),
    Standard(com.pulumi.azurenative.signalrservice.enums.SignalRSkuTier.Standard),
    Premium(com.pulumi.azurenative.signalrservice.enums.SignalRSkuTier.Premium),
    ;

    override fun toJava(): com.pulumi.azurenative.signalrservice.enums.SignalRSkuTier = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.signalrservice.enums.SignalRSkuTier):
            SignalRSkuTier = SignalRSkuTier.values().first { it.javaValue == javaType }
    }
}
