@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.signalrservice.kotlin.inputs

import com.pulumi.azurenative.signalrservice.inputs.GetSignalRReplicaPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property replicaName The name of the replica.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName The name of the resource.
 */
public data class GetSignalRReplicaPlainArgs(
    public val replicaName: String,
    public val resourceGroupName: String,
    public val resourceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.signalrservice.inputs.GetSignalRReplicaPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.signalrservice.inputs.GetSignalRReplicaPlainArgs =
        com.pulumi.azurenative.signalrservice.inputs.GetSignalRReplicaPlainArgs.builder()
            .replicaName(replicaName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSignalRReplicaPlainArgs].
 */
@PulumiTagMarker
public class GetSignalRReplicaPlainArgsBuilder internal constructor() {
    private var replicaName: String? = null

    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    /**
     * @param value The name of the replica.
     */
    @JvmName("aeqkraglsgruywve")
    public suspend fun replicaName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.replicaName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("brnrsjxkfcmujbsv")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("adfpevspoiwpufhf")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    internal fun build(): GetSignalRReplicaPlainArgs = GetSignalRReplicaPlainArgs(
        replicaName = replicaName ?: throw PulumiNullFieldException("replicaName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
    )
}
