@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.signalrservice.kotlin.inputs

import com.pulumi.azurenative.signalrservice.inputs.LiveTraceCategoryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Live trace category configuration of a Microsoft.SignalRService resource.
 * @property enabled Indicates whether or the live trace category is enabled.
 * Available values: true, false.
 * Case insensitive.
 * @property name Gets or sets the live trace category's name.
 * Available values: ConnectivityLogs, MessagingLogs.
 * Case insensitive.
 */
public data class LiveTraceCategoryArgs(
    public val enabled: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.signalrservice.inputs.LiveTraceCategoryArgs> {
    override fun toJava(): com.pulumi.azurenative.signalrservice.inputs.LiveTraceCategoryArgs =
        com.pulumi.azurenative.signalrservice.inputs.LiveTraceCategoryArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LiveTraceCategoryArgs].
 */
@PulumiTagMarker
public class LiveTraceCategoryArgsBuilder internal constructor() {
    private var enabled: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value Indicates whether or the live trace category is enabled.
     * Available values: true, false.
     * Case insensitive.
     */
    @JvmName("rpdwselhlmryinlo")
    public suspend fun enabled(`value`: Output<String>) {
        this.enabled = value
    }

    /**
     * @param value Gets or sets the live trace category's name.
     * Available values: ConnectivityLogs, MessagingLogs.
     * Case insensitive.
     */
    @JvmName("vtcwbpqpgyaethwl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Indicates whether or the live trace category is enabled.
     * Available values: true, false.
     * Case insensitive.
     */
    @JvmName("axjfmmngsyosjoty")
    public suspend fun enabled(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Gets or sets the live trace category's name.
     * Available values: ConnectivityLogs, MessagingLogs.
     * Case insensitive.
     */
    @JvmName("ttnxlhjopnpteris")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): LiveTraceCategoryArgs = LiveTraceCategoryArgs(
        enabled = enabled,
        name = name,
    )
}
