@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.signalrservice.kotlin.inputs

import com.pulumi.azurenative.signalrservice.inputs.LiveTraceConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Live trace configuration of a Microsoft.SignalRService resource.
 * @property categories Gets or sets the list of category configurations.
 * @property enabled Indicates whether or not enable live trace.
 * When it's set to true, live trace client can connect to the service.
 * Otherwise, live trace client can't connect to the service, so that you are unable to receive any log, no matter what you configure in "categories".
 * Available values: true, false.
 * Case insensitive.
 */
public data class LiveTraceConfigurationArgs(
    public val categories: Output<List<LiveTraceCategoryArgs>>? = null,
    public val enabled: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.signalrservice.inputs.LiveTraceConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.signalrservice.inputs.LiveTraceConfigurationArgs =
        com.pulumi.azurenative.signalrservice.inputs.LiveTraceConfigurationArgs.builder()
            .categories(
                categories?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .enabled(enabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LiveTraceConfigurationArgs].
 */
@PulumiTagMarker
public class LiveTraceConfigurationArgsBuilder internal constructor() {
    private var categories: Output<List<LiveTraceCategoryArgs>>? = null

    private var enabled: Output<String>? = null

    /**
     * @param value Gets or sets the list of category configurations.
     */
    @JvmName("agslcomxwxxjelsf")
    public suspend fun categories(`value`: Output<List<LiveTraceCategoryArgs>>) {
        this.categories = value
    }

    @JvmName("mhrobvidwnxhxbyd")
    public suspend fun categories(vararg values: Output<LiveTraceCategoryArgs>) {
        this.categories = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the list of category configurations.
     */
    @JvmName("wbyxtehykrnooqnh")
    public suspend fun categories(values: List<Output<LiveTraceCategoryArgs>>) {
        this.categories = Output.all(values)
    }

    /**
     * @param value Indicates whether or not enable live trace.
     * When it's set to true, live trace client can connect to the service.
     * Otherwise, live trace client can't connect to the service, so that you are unable to receive any log, no matter what you configure in "categories".
     * Available values: true, false.
     * Case insensitive.
     */
    @JvmName("gqrsnwmygbqqhypo")
    public suspend fun enabled(`value`: Output<String>) {
        this.enabled = value
    }

    /**
     * @param value Gets or sets the list of category configurations.
     */
    @JvmName("ueejnaclomgusfgj")
    public suspend fun categories(`value`: List<LiveTraceCategoryArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.categories = mapped
    }

    /**
     * @param argument Gets or sets the list of category configurations.
     */
    @JvmName("rbylrtfitcbdjgaw")
    public suspend fun categories(argument: List<suspend LiveTraceCategoryArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LiveTraceCategoryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.categories = mapped
    }

    /**
     * @param argument Gets or sets the list of category configurations.
     */
    @JvmName("xdopygnmvkerkjoi")
    public suspend fun categories(vararg argument: suspend LiveTraceCategoryArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            LiveTraceCategoryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.categories = mapped
    }

    /**
     * @param argument Gets or sets the list of category configurations.
     */
    @JvmName("fhbscdymhcrdveuq")
    public suspend fun categories(argument: suspend LiveTraceCategoryArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(LiveTraceCategoryArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.categories = mapped
    }

    /**
     * @param values Gets or sets the list of category configurations.
     */
    @JvmName("kiwuugjwotaelfya")
    public suspend fun categories(vararg values: LiveTraceCategoryArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.categories = mapped
    }

    /**
     * @param value Indicates whether or not enable live trace.
     * When it's set to true, live trace client can connect to the service.
     * Otherwise, live trace client can't connect to the service, so that you are unable to receive any log, no matter what you configure in "categories".
     * Available values: true, false.
     * Case insensitive.
     */
    @JvmName("okervlfghxqrlndy")
    public suspend fun enabled(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): LiveTraceConfigurationArgs = LiveTraceConfigurationArgs(
        categories = categories,
        enabled = enabled,
    )
}
