@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.signalrservice.kotlin.inputs

import com.pulumi.azurenative.signalrservice.inputs.ManagedIdentitySettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Managed identity settings for upstream.
 * @property resource The Resource indicating the App ID URI of the target resource.
 * It also appears in the aud (audience) claim of the issued token.
 */
public data class ManagedIdentitySettingsArgs(
    public val resource: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.signalrservice.inputs.ManagedIdentitySettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.signalrservice.inputs.ManagedIdentitySettingsArgs =
        com.pulumi.azurenative.signalrservice.inputs.ManagedIdentitySettingsArgs.builder()
            .resource(resource?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedIdentitySettingsArgs].
 */
@PulumiTagMarker
public class ManagedIdentitySettingsArgsBuilder internal constructor() {
    private var resource: Output<String>? = null

    /**
     * @param value The Resource indicating the App ID URI of the target resource.
     * It also appears in the aud (audience) claim of the issued token.
     */
    @JvmName("xvtheammbrqxdtcl")
    public suspend fun resource(`value`: Output<String>) {
        this.resource = value
    }

    /**
     * @param value The Resource indicating the App ID URI of the target resource.
     * It also appears in the aud (audience) claim of the issued token.
     */
    @JvmName("qrenekvxnlaslhio")
    public suspend fun resource(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resource = mapped
    }

    internal fun build(): ManagedIdentitySettingsArgs = ManagedIdentitySettingsArgs(
        resource = resource,
    )
}
