@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.signalrservice.kotlin.inputs

import com.pulumi.azurenative.signalrservice.inputs.ResourceLogCategoryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource log category configuration of a Microsoft.SignalRService resource.
 * @property enabled Indicates whether or the resource log category is enabled.
 * Available values: true, false.
 * Case insensitive.
 * @property name Gets or sets the resource log category's name.
 * Available values: ConnectivityLogs, MessagingLogs.
 * Case insensitive.
 */
public data class ResourceLogCategoryArgs(
    public val enabled: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.signalrservice.inputs.ResourceLogCategoryArgs> {
    override fun toJava(): com.pulumi.azurenative.signalrservice.inputs.ResourceLogCategoryArgs =
        com.pulumi.azurenative.signalrservice.inputs.ResourceLogCategoryArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceLogCategoryArgs].
 */
@PulumiTagMarker
public class ResourceLogCategoryArgsBuilder internal constructor() {
    private var enabled: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value Indicates whether or the resource log category is enabled.
     * Available values: true, false.
     * Case insensitive.
     */
    @JvmName("dlxridqyemoeoltr")
    public suspend fun enabled(`value`: Output<String>) {
        this.enabled = value
    }

    /**
     * @param value Gets or sets the resource log category's name.
     * Available values: ConnectivityLogs, MessagingLogs.
     * Case insensitive.
     */
    @JvmName("xgycgnettgthchrp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Indicates whether or the resource log category is enabled.
     * Available values: true, false.
     * Case insensitive.
     */
    @JvmName("kxvtrrqeomnrkxpb")
    public suspend fun enabled(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Gets or sets the resource log category's name.
     * Available values: ConnectivityLogs, MessagingLogs.
     * Case insensitive.
     */
    @JvmName("nujggjgwuoqbggtg")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ResourceLogCategoryArgs = ResourceLogCategoryArgs(
        enabled = enabled,
        name = name,
    )
}
