@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.signalrservice.kotlin.inputs

import com.pulumi.azurenative.signalrservice.inputs.ServerlessUpstreamSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The settings for the Upstream when the service is in server-less mode.
 * @property templates Gets or sets the list of Upstream URL templates. Order matters, and the first matching template takes effects.
 */
public data class ServerlessUpstreamSettingsArgs(
    public val templates: Output<List<UpstreamTemplateArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.signalrservice.inputs.ServerlessUpstreamSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.signalrservice.inputs.ServerlessUpstreamSettingsArgs =
        com.pulumi.azurenative.signalrservice.inputs.ServerlessUpstreamSettingsArgs.builder()
            .templates(
                templates?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ServerlessUpstreamSettingsArgs].
 */
@PulumiTagMarker
public class ServerlessUpstreamSettingsArgsBuilder internal constructor() {
    private var templates: Output<List<UpstreamTemplateArgs>>? = null

    /**
     * @param value Gets or sets the list of Upstream URL templates. Order matters, and the first matching template takes effects.
     */
    @JvmName("svnistskdagbkuru")
    public suspend fun templates(`value`: Output<List<UpstreamTemplateArgs>>) {
        this.templates = value
    }

    @JvmName("vwqqenadqrnwnhjw")
    public suspend fun templates(vararg values: Output<UpstreamTemplateArgs>) {
        this.templates = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the list of Upstream URL templates. Order matters, and the first matching template takes effects.
     */
    @JvmName("kujyfteqilyffbxb")
    public suspend fun templates(values: List<Output<UpstreamTemplateArgs>>) {
        this.templates = Output.all(values)
    }

    /**
     * @param value Gets or sets the list of Upstream URL templates. Order matters, and the first matching template takes effects.
     */
    @JvmName("eaucwaofuigamtnw")
    public suspend fun templates(`value`: List<UpstreamTemplateArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templates = mapped
    }

    /**
     * @param argument Gets or sets the list of Upstream URL templates. Order matters, and the first matching template takes effects.
     */
    @JvmName("gfqcdobqytvuluma")
    public suspend fun templates(argument: List<suspend UpstreamTemplateArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            UpstreamTemplateArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.templates = mapped
    }

    /**
     * @param argument Gets or sets the list of Upstream URL templates. Order matters, and the first matching template takes effects.
     */
    @JvmName("glnwyuyymggatgeu")
    public suspend fun templates(vararg argument: suspend UpstreamTemplateArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            UpstreamTemplateArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.templates = mapped
    }

    /**
     * @param argument Gets or sets the list of Upstream URL templates. Order matters, and the first matching template takes effects.
     */
    @JvmName("kssitrkrkfcjkprl")
    public suspend fun templates(argument: suspend UpstreamTemplateArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(UpstreamTemplateArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.templates = mapped
    }

    /**
     * @param values Gets or sets the list of Upstream URL templates. Order matters, and the first matching template takes effects.
     */
    @JvmName("srmshcdpodektgwu")
    public suspend fun templates(vararg values: UpstreamTemplateArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.templates = mapped
    }

    internal fun build(): ServerlessUpstreamSettingsArgs = ServerlessUpstreamSettingsArgs(
        templates = templates,
    )
}
