@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.signalrservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Live trace category configuration of a Microsoft.SignalRService resource.
 * @property enabled Indicates whether or the live trace category is enabled.
 * Available values: true, false.
 * Case insensitive.
 * @property name Gets or sets the live trace category's name.
 * Available values: ConnectivityLogs, MessagingLogs.
 * Case insensitive.
 */
public data class LiveTraceCategoryResponse(
    public val enabled: String? = null,
    public val name: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.signalrservice.outputs.LiveTraceCategoryResponse):
            LiveTraceCategoryResponse = LiveTraceCategoryResponse(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
