@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.signalrservice.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The billing information of the resource.
 * @property capacity Optional, integer. The unit count of the resource. 1 by default.
 * If present, following values are allowed:
 *     Free: 1;
 *     Standard: 1,2,3,4,5,6,7,8,9,10,20,30,40,50,60,70,80,90,100;
 *     Premium:  1,2,3,4,5,6,7,8,9,10,20,30,40,50,60,70,80,90,100;
 * @property family Not used. Retained for future use.
 * @property name The name of the SKU. Required.
 * Allowed values: Standard_S1, Free_F1, Premium_P1
 * @property size Not used. Retained for future use.
 * @property tier Optional tier of this particular SKU. 'Standard' or 'Free'.
 * `Basic` is deprecated, use `Standard` instead.
 */
public data class ResourceSkuResponse(
    public val capacity: Int? = null,
    public val family: String,
    public val name: String,
    public val size: String,
    public val tier: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.signalrservice.outputs.ResourceSkuResponse):
            ResourceSkuResponse = ResourceSkuResponse(
            capacity = javaType.capacity().map({ args0 -> args0 }).orElse(null),
            family = javaType.family(),
            name = javaType.name(),
            size = javaType.size(),
            tier = javaType.tier().map({ args0 -> args0 }).orElse(null),
        )
    }
}
