@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.signalrservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Network ACLs for the resource
 * @property defaultAction Azure Networking ACL Action.
 * @property privateEndpoints ACLs for requests from private endpoints
 * @property publicNetwork Network ACL
 */
public data class SignalRNetworkACLsResponse(
    public val defaultAction: String? = null,
    public val privateEndpoints: List<PrivateEndpointACLResponse>? = null,
    public val publicNetwork: NetworkACLResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.signalrservice.outputs.SignalRNetworkACLsResponse):
            SignalRNetworkACLsResponse = SignalRNetworkACLsResponse(
            defaultAction = javaType.defaultAction().map({ args0 -> args0 }).orElse(null),
            privateEndpoints = javaType.privateEndpoints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.signalrservice.kotlin.outputs.PrivateEndpointACLResponse.Companion.toKotlin(args0)
                })
            }),
            publicNetwork = javaType.publicNetwork().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.signalrservice.kotlin.outputs.NetworkACLResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
