@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.signalrservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Upstream template item settings. It defines the Upstream URL of the incoming requests.
 * The template defines the pattern of the event, the hub or the category of the incoming request that matches current URL template.
 * @property auth Upstream auth settings. If not set, no auth is used for upstream messages.
 * @property categoryPattern Gets or sets the matching pattern for category names. If not set, it matches any category.
 * There are 3 kind of patterns supported:
 *     1. "*", it to matches any category name.
 *     2. Combine multiple categories with ",", for example "connections,messages", it matches category "connections" and "messages".
 *     3. The single category name, for example, "connections", it matches the category "connections".
 * @property eventPattern Gets or sets the matching pattern for event names. If not set, it matches any event.
 * There are 3 kind of patterns supported:
 *     1. "*", it to matches any event name.
 *     2. Combine multiple events with ",", for example "connect,disconnect", it matches event "connect" and "disconnect".
 *     3. The single event name, for example, "connect", it matches "connect".
 * @property hubPattern Gets or sets the matching pattern for hub names. If not set, it matches any hub.
 * There are 3 kind of patterns supported:
 *     1. "*", it to matches any hub name.
 *     2. Combine multiple hubs with ",", for example "hub1,hub2", it matches "hub1" and "hub2".
 *     3. The single hub name, for example, "hub1", it matches "hub1".
 * @property urlTemplate Gets or sets the Upstream URL template. You can use 3 predefined parameters {hub}, {category} {event} inside the template, the value of the Upstream URL is dynamically calculated when the client request comes in.
 * For example, if the urlTemplate is `http://example.com/{hub}/api/{event}`, with a client request from hub `chat` connects, it will first POST to this URL: `http://example.com/chat/api/connect`.
 */
public data class UpstreamTemplateResponse(
    public val auth: UpstreamAuthSettingsResponse? = null,
    public val categoryPattern: String? = null,
    public val eventPattern: String? = null,
    public val hubPattern: String? = null,
    public val urlTemplate: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.signalrservice.outputs.UpstreamTemplateResponse):
            UpstreamTemplateResponse = UpstreamTemplateResponse(
            auth = javaType.auth().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.signalrservice.kotlin.outputs.UpstreamAuthSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            categoryPattern = javaType.categoryPattern().map({ args0 -> args0 }).orElse(null),
            eventPattern = javaType.eventPattern().map({ args0 -> args0 }).orElse(null),
            hubPattern = javaType.hubPattern().map({ args0 -> args0 }).orElse(null),
            urlTemplate = javaType.urlTemplate(),
        )
    }
}
