@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.solutions.kotlin.inputs

import com.pulumi.azurenative.solutions.inputs.ApplicationAuthorizationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The managed application provider authorization.
 * @property principalId The provider's principal identifier. This is the identity that the provider will use to call ARM to manage the managed application resources.
 * @property roleDefinitionId The provider's role definition identifier. This role will define all the permissions that the provider must have on the managed application's container resource group. This role definition cannot have permission to delete the resource group.
 */
public data class ApplicationAuthorizationArgs(
    public val principalId: Output<String>,
    public val roleDefinitionId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.solutions.inputs.ApplicationAuthorizationArgs> {
    override fun toJava(): com.pulumi.azurenative.solutions.inputs.ApplicationAuthorizationArgs =
        com.pulumi.azurenative.solutions.inputs.ApplicationAuthorizationArgs.builder()
            .principalId(principalId.applyValue({ args0 -> args0 }))
            .roleDefinitionId(roleDefinitionId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationAuthorizationArgs].
 */
@PulumiTagMarker
public class ApplicationAuthorizationArgsBuilder internal constructor() {
    private var principalId: Output<String>? = null

    private var roleDefinitionId: Output<String>? = null

    /**
     * @param value The provider's principal identifier. This is the identity that the provider will use to call ARM to manage the managed application resources.
     */
    @JvmName("eygdngygeaapavcp")
    public suspend fun principalId(`value`: Output<String>) {
        this.principalId = value
    }

    /**
     * @param value The provider's role definition identifier. This role will define all the permissions that the provider must have on the managed application's container resource group. This role definition cannot have permission to delete the resource group.
     */
    @JvmName("bkhbcphgyhgljhag")
    public suspend fun roleDefinitionId(`value`: Output<String>) {
        this.roleDefinitionId = value
    }

    /**
     * @param value The provider's principal identifier. This is the identity that the provider will use to call ARM to manage the managed application resources.
     */
    @JvmName("yavuxavswywtuuke")
    public suspend fun principalId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.principalId = mapped
    }

    /**
     * @param value The provider's role definition identifier. This role will define all the permissions that the provider must have on the managed application's container resource group. This role definition cannot have permission to delete the resource group.
     */
    @JvmName("qmucswttedrrjfmc")
    public suspend fun roleDefinitionId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleDefinitionId = mapped
    }

    internal fun build(): ApplicationAuthorizationArgs = ApplicationAuthorizationArgs(
        principalId = principalId ?: throw PulumiNullFieldException("principalId"),
        roleDefinitionId = roleDefinitionId ?: throw PulumiNullFieldException("roleDefinitionId"),
    )
}
