@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.solutions.kotlin.inputs

import com.pulumi.azurenative.solutions.inputs.ApplicationDeploymentPolicyArgs.builder
import com.pulumi.azurenative.solutions.kotlin.enums.DeploymentMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Managed application deployment policy.
 * @property deploymentMode The managed application deployment mode.
 */
public data class ApplicationDeploymentPolicyArgs(
    public val deploymentMode: Output<Either<String, DeploymentMode>>,
) : ConvertibleToJava<com.pulumi.azurenative.solutions.inputs.ApplicationDeploymentPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.solutions.inputs.ApplicationDeploymentPolicyArgs =
        com.pulumi.azurenative.solutions.inputs.ApplicationDeploymentPolicyArgs.builder()
            .deploymentMode(
                deploymentMode.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ApplicationDeploymentPolicyArgs].
 */
@PulumiTagMarker
public class ApplicationDeploymentPolicyArgsBuilder internal constructor() {
    private var deploymentMode: Output<Either<String, DeploymentMode>>? = null

    /**
     * @param value The managed application deployment mode.
     */
    @JvmName("gagxxgloyubkdupo")
    public suspend fun deploymentMode(`value`: Output<Either<String, DeploymentMode>>) {
        this.deploymentMode = value
    }

    /**
     * @param value The managed application deployment mode.
     */
    @JvmName("wwxcldwirxewyspf")
    public suspend fun deploymentMode(`value`: Either<String, DeploymentMode>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deploymentMode = mapped
    }

    /**
     * @param value The managed application deployment mode.
     */
    @JvmName("mkyaxohaqpuxtdkv")
    public fun deploymentMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DeploymentMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deploymentMode = mapped
    }

    /**
     * @param value The managed application deployment mode.
     */
    @JvmName("eybgyoifnedmlxcm")
    public fun deploymentMode(`value`: DeploymentMode) {
        val toBeMapped = Either.ofRight<String, DeploymentMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deploymentMode = mapped
    }

    internal fun build(): ApplicationDeploymentPolicyArgs = ApplicationDeploymentPolicyArgs(
        deploymentMode = deploymentMode ?: throw PulumiNullFieldException("deploymentMode"),
    )
}
