@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.solutions.kotlin.inputs

import com.pulumi.azurenative.solutions.inputs.GetApplicationDefinitionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property applicationDefinitionName The name of the managed application definition.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetApplicationDefinitionPlainArgs(
    public val applicationDefinitionName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.solutions.inputs.GetApplicationDefinitionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.solutions.inputs.GetApplicationDefinitionPlainArgs =
        com.pulumi.azurenative.solutions.inputs.GetApplicationDefinitionPlainArgs.builder()
            .applicationDefinitionName(applicationDefinitionName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetApplicationDefinitionPlainArgs].
 */
@PulumiTagMarker
public class GetApplicationDefinitionPlainArgsBuilder internal constructor() {
    private var applicationDefinitionName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the managed application definition.
     */
    @JvmName("vnecnesajigfriwk")
    public suspend fun applicationDefinitionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.applicationDefinitionName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kycpsqalnvsivgcr")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetApplicationDefinitionPlainArgs = GetApplicationDefinitionPlainArgs(
        applicationDefinitionName = applicationDefinitionName ?: throw
            PulumiNullFieldException("applicationDefinitionName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
