@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.solutions.kotlin.inputs

import com.pulumi.azurenative.solutions.inputs.JitApproverDefinitionArgs.builder
import com.pulumi.azurenative.solutions.kotlin.enums.JitApproverType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * JIT approver definition.
 * @property displayName The approver display name.
 * @property id The approver service principal Id.
 * @property type The approver type.
 */
public data class JitApproverDefinitionArgs(
    public val displayName: Output<String>? = null,
    public val id: Output<String>,
    public val type: Output<Either<String, JitApproverType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.solutions.inputs.JitApproverDefinitionArgs> {
    override fun toJava(): com.pulumi.azurenative.solutions.inputs.JitApproverDefinitionArgs =
        com.pulumi.azurenative.solutions.inputs.JitApproverDefinitionArgs.builder()
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .id(id.applyValue({ args0 -> args0 }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [JitApproverDefinitionArgs].
 */
@PulumiTagMarker
public class JitApproverDefinitionArgsBuilder internal constructor() {
    private var displayName: Output<String>? = null

    private var id: Output<String>? = null

    private var type: Output<Either<String, JitApproverType>>? = null

    /**
     * @param value The approver display name.
     */
    @JvmName("atexxivtvmhfetlm")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The approver service principal Id.
     */
    @JvmName("fsuufnbdbgmfpjrt")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The approver type.
     */
    @JvmName("mlbohdsqxgshwrlc")
    public suspend fun type(`value`: Output<Either<String, JitApproverType>>) {
        this.type = value
    }

    /**
     * @param value The approver display name.
     */
    @JvmName("ubqqornoqprmkfnw")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The approver service principal Id.
     */
    @JvmName("kuabdnijisspmfbk")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The approver type.
     */
    @JvmName("yajylglnafsdklon")
    public suspend fun type(`value`: Either<String, JitApproverType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The approver type.
     */
    @JvmName("qihesnwrtpgcarrs")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, JitApproverType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The approver type.
     */
    @JvmName("hkptcxolhkkmomcc")
    public fun type(`value`: JitApproverType) {
        val toBeMapped = Either.ofRight<String, JitApproverType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): JitApproverDefinitionArgs = JitApproverDefinitionArgs(
        displayName = displayName,
        id = id ?: throw PulumiNullFieldException("id"),
        type = type,
    )
}
